package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.EventRecord;
import com.xforceplus.ultraman.app.jctke.service.IEventRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-05
 */
@RestController
public class EventRecordController {

  @Autowired
  private IEventRecordService eventRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param eventRecord ${table.comment}
   * @return
   */
  @GetMapping("/eventrecords" )
  public XfR getEventRecords(XfPage page, EventRecord eventRecord) {
    return XfR.ok(eventRecordServiceImpl.page(page, Wrappers.query(eventRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/eventrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(eventRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param eventRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/eventrecords")
  public XfR save(@RequestBody EventRecord eventRecord) {
     return XfR.ok(eventRecordServiceImpl.save(eventRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param eventRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/eventrecords/{id}")
  public XfR putUpdate(@RequestBody EventRecord eventRecord,@PathVariable Long id) {
      eventRecord.setId(id);
      return XfR.ok(eventRecordServiceImpl.updateById(eventRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param eventRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/eventrecords/{id}")
  public XfR patchUpdate(@RequestBody EventRecord eventRecord,@PathVariable Long id) {
      EventRecord upeventRecord = eventRecordServiceImpl.getById(id);
      if(upeventRecord != null){
        upeventRecord = ObjectCopyUtils.copyProperties(eventRecord,upeventRecord,true);
      }
      return XfR.ok(eventRecordServiceImpl.updateById(upeventRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/eventrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(eventRecordServiceImpl.removeById(id));
  }

  @PostMapping("/eventrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "event_record");
     params.put("request", condition);

     return XfR.ok(eventRecordServiceImpl.querys(params));
  }

}
