package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.PurchaseOrderInit;
import com.xforceplus.ultraman.app.jctke.service.IPurchaseOrderInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 前端控制器
 *
 * @author ultraman
 * @date 2022-12-05
 */
@RestController
public class PurchaseOrderInitController {

  @Autowired
  private IPurchaseOrderInitService purchaseOrderInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaseOrderInit 
   * @return
   */
  @GetMapping("/purchaseorderinits" )
  public XfR getPurchaseOrderInits(XfPage page, PurchaseOrderInit purchaseOrderInit) {
    return XfR.ok(purchaseOrderInitServiceImpl.page(page, Wrappers.query(purchaseOrderInit)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaseorderinits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaseOrderInitServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param purchaseOrderInit 
   * @return XfR
   */
  @PostMapping("/purchaseorderinits")
  public XfR save(@RequestBody PurchaseOrderInit purchaseOrderInit) {
     return XfR.ok(purchaseOrderInitServiceImpl.save(purchaseOrderInit));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param purchaseOrderInit 
   * @return XfR
   */
  @PutMapping("/purchaseorderinits/{id}")
  public XfR putUpdate(@RequestBody PurchaseOrderInit purchaseOrderInit,@PathVariable Long id) {
      purchaseOrderInit.setId(id);
      return XfR.ok(purchaseOrderInitServiceImpl.updateById(purchaseOrderInit));
  }

  /**
   * 修改-传入修改的数据
   * @param purchaseOrderInit 
   * @return XfR
   */
  @PatchMapping("/purchaseorderinits/{id}")
  public XfR patchUpdate(@RequestBody PurchaseOrderInit purchaseOrderInit,@PathVariable Long id) {
      PurchaseOrderInit uppurchaseOrderInit = purchaseOrderInitServiceImpl.getById(id);
      if(uppurchaseOrderInit != null){
        uppurchaseOrderInit = ObjectCopyUtils.copyProperties(purchaseOrderInit,uppurchaseOrderInit,true);
      }
      return XfR.ok(purchaseOrderInitServiceImpl.updateById(uppurchaseOrderInit));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaseorderinits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaseOrderInitServiceImpl.removeById(id));
  }

  @PostMapping("/purchaseorderinits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchase_order_init");
     params.put("request", condition);

     return XfR.ok(purchaseOrderInitServiceImpl.querys(params));
  }

}
