package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.Customer;
import com.xforceplus.ultraman.app.jctke.service.ICustomerService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-02-13
 */
@RestController
public class CustomerController {

  @Autowired
  private ICustomerService customerServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customer ${table.comment}
   * @return
   */
  @GetMapping("/customers" )
  public XfR getCustomers(XfPage page, Customer customer) {
    return XfR.ok(customerServiceImpl.page(page, Wrappers.query(customer)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/customers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customerServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param customer ${table.comment}
   * @return XfR
   */
  @PostMapping("/customers")
  public XfR save(@RequestBody Customer customer) {
     return XfR.ok(customerServiceImpl.save(customer));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param customer ${table.comment}
   * @return XfR
   */
  @PutMapping("/customers/{id}")
  public XfR putUpdate(@RequestBody Customer customer,@PathVariable Long id) {
      customer.setId(id);
      return XfR.ok(customerServiceImpl.updateById(customer));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param customer ${table.comment}
   * @return XfR
   */
  @PatchMapping("/customers/{id}")
  public XfR patchUpdate(@RequestBody Customer customer,@PathVariable Long id) {
      Customer upcustomer = customerServiceImpl.getById(id);
      if(upcustomer != null){
        upcustomer = ObjectCopyUtils.copyProperties(customer,upcustomer,true);
      }
      return XfR.ok(customerServiceImpl.updateById(upcustomer));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customerServiceImpl.removeById(id));
  }

  @PostMapping("/customers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customer");
     params.put("request", condition);

     return XfR.ok(customerServiceImpl.querys(params));
  }

}
