package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.RpaResponse;
import com.xforceplus.ultraman.app.jctke.service.IRpaResponseService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * Rpa任务回执前端控制器
 *
 * @author ultraman
 * @date 2023-02-13
 */
@RestController
public class RpaResponseController {

  @Autowired
  private IRpaResponseService rpaResponseServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param rpaResponse Rpa任务回执
   * @return
   */
  @GetMapping("/rparesponses" )
  public XfR getRpaResponses(XfPage page, RpaResponse rpaResponse) {
    return XfR.ok(rpaResponseServiceImpl.page(page, Wrappers.query(rpaResponse)));
  }

  /**
   * 通过id查询Rpa任务回执
   * @param  id
   * @return XfR
   */
  @GetMapping("/rparesponses/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(rpaResponseServiceImpl.getById(id));
  }

  /**
   * 新增Rpa任务回执
   * @param rpaResponse Rpa任务回执
   * @return XfR
   */
  @PostMapping("/rparesponses")
  public XfR save(@RequestBody RpaResponse rpaResponse) {
     return XfR.ok(rpaResponseServiceImpl.save(rpaResponse));
  }

  /**
   * 修改-传入修改后的全部数据Rpa任务回执
   * @param rpaResponse Rpa任务回执
   * @return XfR
   */
  @PutMapping("/rparesponses/{id}")
  public XfR putUpdate(@RequestBody RpaResponse rpaResponse,@PathVariable Long id) {
      rpaResponse.setId(id);
      return XfR.ok(rpaResponseServiceImpl.updateById(rpaResponse));
  }

  /**
   * 修改-传入修改的数据Rpa任务回执
   * @param rpaResponse Rpa任务回执
   * @return XfR
   */
  @PatchMapping("/rparesponses/{id}")
  public XfR patchUpdate(@RequestBody RpaResponse rpaResponse,@PathVariable Long id) {
      RpaResponse uprpaResponse = rpaResponseServiceImpl.getById(id);
      if(uprpaResponse != null){
        uprpaResponse = ObjectCopyUtils.copyProperties(rpaResponse,uprpaResponse,true);
      }
      return XfR.ok(rpaResponseServiceImpl.updateById(uprpaResponse));
  }

  /**
   * 通过id删除Rpa任务回执
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/rparesponses/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(rpaResponseServiceImpl.removeById(id));
  }

  @PostMapping("/rparesponses/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "rpa_response");
     params.put("request", condition);

     return XfR.ok(rpaResponseServiceImpl.querys(params));
  }

}
