package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.EmailRecord;
import com.xforceplus.ultraman.app.jctke.service.IEmailRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-02-18
 */
@RestController
public class EmailRecordController {

  @Autowired
  private IEmailRecordService emailRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param emailRecord ${table.comment}
   * @return
   */
  @GetMapping("/emailrecords" )
  public XfR getEmailRecords(XfPage page, EmailRecord emailRecord) {
    return XfR.ok(emailRecordServiceImpl.page(page, Wrappers.query(emailRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/emailrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(emailRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param emailRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/emailrecords")
  public XfR save(@RequestBody EmailRecord emailRecord) {
     return XfR.ok(emailRecordServiceImpl.save(emailRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param emailRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/emailrecords/{id}")
  public XfR putUpdate(@RequestBody EmailRecord emailRecord,@PathVariable Long id) {
      emailRecord.setId(id);
      return XfR.ok(emailRecordServiceImpl.updateById(emailRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param emailRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/emailrecords/{id}")
  public XfR patchUpdate(@RequestBody EmailRecord emailRecord,@PathVariable Long id) {
      EmailRecord upemailRecord = emailRecordServiceImpl.getById(id);
      if(upemailRecord != null){
        upemailRecord = ObjectCopyUtils.copyProperties(emailRecord,upemailRecord,true);
      }
      return XfR.ok(emailRecordServiceImpl.updateById(upemailRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/emailrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(emailRecordServiceImpl.removeById(id));
  }

  @PostMapping("/emailrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "email_record");
     params.put("request", condition);

     return XfR.ok(emailRecordServiceImpl.querys(params));
  }

}
