package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.InvoiceNoticeBillRelation;
import com.xforceplus.ultraman.app.jctke.service.IInvoiceNoticeBillRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-02-18
 */
@RestController
public class InvoiceNoticeBillRelationController {

  @Autowired
  private IInvoiceNoticeBillRelationService invoiceNoticeBillRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceNoticeBillRelation ${table.comment}
   * @return
   */
  @GetMapping("/invoicenoticebillrelations" )
  public XfR getInvoiceNoticeBillRelations(XfPage page, InvoiceNoticeBillRelation invoiceNoticeBillRelation) {
    return XfR.ok(invoiceNoticeBillRelationServiceImpl.page(page, Wrappers.query(invoiceNoticeBillRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicenoticebillrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceNoticeBillRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceNoticeBillRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicenoticebillrelations")
  public XfR save(@RequestBody InvoiceNoticeBillRelation invoiceNoticeBillRelation) {
     return XfR.ok(invoiceNoticeBillRelationServiceImpl.save(invoiceNoticeBillRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceNoticeBillRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicenoticebillrelations/{id}")
  public XfR putUpdate(@RequestBody InvoiceNoticeBillRelation invoiceNoticeBillRelation,@PathVariable Long id) {
      invoiceNoticeBillRelation.setId(id);
      return XfR.ok(invoiceNoticeBillRelationServiceImpl.updateById(invoiceNoticeBillRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceNoticeBillRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicenoticebillrelations/{id}")
  public XfR patchUpdate(@RequestBody InvoiceNoticeBillRelation invoiceNoticeBillRelation,@PathVariable Long id) {
      InvoiceNoticeBillRelation upinvoiceNoticeBillRelation = invoiceNoticeBillRelationServiceImpl.getById(id);
      if(upinvoiceNoticeBillRelation != null){
        upinvoiceNoticeBillRelation = ObjectCopyUtils.copyProperties(invoiceNoticeBillRelation,upinvoiceNoticeBillRelation,true);
      }
      return XfR.ok(invoiceNoticeBillRelationServiceImpl.updateById(upinvoiceNoticeBillRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicenoticebillrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceNoticeBillRelationServiceImpl.removeById(id));
  }

  @PostMapping("/invoicenoticebillrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_notice_bill_relation");
     params.put("request", condition);

     return XfR.ok(invoiceNoticeBillRelationServiceImpl.querys(params));
  }

}
