package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.ReceiptInitFailedHistory;
import com.xforceplus.ultraman.app.jctke.service.IReceiptInitFailedHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-02-18
 */
@RestController
public class ReceiptInitFailedHistoryController {

  @Autowired
  private IReceiptInitFailedHistoryService receiptInitFailedHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receiptInitFailedHistory ${table.comment}
   * @return
   */
  @GetMapping("/receiptinitfailedhistorys" )
  public XfR getReceiptInitFailedHistorys(XfPage page, ReceiptInitFailedHistory receiptInitFailedHistory) {
    return XfR.ok(receiptInitFailedHistoryServiceImpl.page(page, Wrappers.query(receiptInitFailedHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/receiptinitfailedhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receiptInitFailedHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param receiptInitFailedHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/receiptinitfailedhistorys")
  public XfR save(@RequestBody ReceiptInitFailedHistory receiptInitFailedHistory) {
     return XfR.ok(receiptInitFailedHistoryServiceImpl.save(receiptInitFailedHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param receiptInitFailedHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/receiptinitfailedhistorys/{id}")
  public XfR putUpdate(@RequestBody ReceiptInitFailedHistory receiptInitFailedHistory,@PathVariable Long id) {
      receiptInitFailedHistory.setId(id);
      return XfR.ok(receiptInitFailedHistoryServiceImpl.updateById(receiptInitFailedHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param receiptInitFailedHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/receiptinitfailedhistorys/{id}")
  public XfR patchUpdate(@RequestBody ReceiptInitFailedHistory receiptInitFailedHistory,@PathVariable Long id) {
      ReceiptInitFailedHistory upreceiptInitFailedHistory = receiptInitFailedHistoryServiceImpl.getById(id);
      if(upreceiptInitFailedHistory != null){
        upreceiptInitFailedHistory = ObjectCopyUtils.copyProperties(receiptInitFailedHistory,upreceiptInitFailedHistory,true);
      }
      return XfR.ok(receiptInitFailedHistoryServiceImpl.updateById(upreceiptInitFailedHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receiptinitfailedhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receiptInitFailedHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/receiptinitfailedhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "receipt_init_failed_history");
     params.put("request", condition);

     return XfR.ok(receiptInitFailedHistoryServiceImpl.querys(params));
  }

}
