package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.SettlementOrder;
import com.xforceplus.ultraman.app.jctke.service.ISettlementOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-02-18
 */
@RestController
public class SettlementOrderController {

  @Autowired
  private ISettlementOrderService settlementOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementOrder ${table.comment}
   * @return
   */
  @GetMapping("/settlementorders" )
  public XfR getSettlementOrders(XfPage page, SettlementOrder settlementOrder) {
    return XfR.ok(settlementOrderServiceImpl.page(page, Wrappers.query(settlementOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param settlementOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/settlementorders")
  public XfR save(@RequestBody SettlementOrder settlementOrder) {
     return XfR.ok(settlementOrderServiceImpl.save(settlementOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param settlementOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/settlementorders/{id}")
  public XfR putUpdate(@RequestBody SettlementOrder settlementOrder,@PathVariable Long id) {
      settlementOrder.setId(id);
      return XfR.ok(settlementOrderServiceImpl.updateById(settlementOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param settlementOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/settlementorders/{id}")
  public XfR patchUpdate(@RequestBody SettlementOrder settlementOrder,@PathVariable Long id) {
      SettlementOrder upsettlementOrder = settlementOrderServiceImpl.getById(id);
      if(upsettlementOrder != null){
        upsettlementOrder = ObjectCopyUtils.copyProperties(settlementOrder,upsettlementOrder,true);
      }
      return XfR.ok(settlementOrderServiceImpl.updateById(upsettlementOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementOrderServiceImpl.removeById(id));
  }

  @PostMapping("/settlementorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_order");
     params.put("request", condition);

     return XfR.ok(settlementOrderServiceImpl.querys(params));
  }

}
