package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.AddPO;
import com.xforceplus.ultraman.app.jctke.service.IAddPOService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-03
 */
@RestController
public class AddPOController {

  @Autowired
  private IAddPOService addPOServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param addPO ${table.comment}
   * @return
   */
  @GetMapping("/addpos" )
  public XfR getAddPOs(XfPage page, AddPO addPO) {
    return XfR.ok(addPOServiceImpl.page(page, Wrappers.query(addPO)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/addpos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(addPOServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param addPO ${table.comment}
   * @return XfR
   */
  @PostMapping("/addpos")
  public XfR save(@RequestBody AddPO addPO) {
     return XfR.ok(addPOServiceImpl.save(addPO));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param addPO ${table.comment}
   * @return XfR
   */
  @PutMapping("/addpos/{id}")
  public XfR putUpdate(@RequestBody AddPO addPO,@PathVariable Long id) {
      addPO.setId(id);
      return XfR.ok(addPOServiceImpl.updateById(addPO));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param addPO ${table.comment}
   * @return XfR
   */
  @PatchMapping("/addpos/{id}")
  public XfR patchUpdate(@RequestBody AddPO addPO,@PathVariable Long id) {
      AddPO upaddPO = addPOServiceImpl.getById(id);
      if(upaddPO != null){
        upaddPO = ObjectCopyUtils.copyProperties(addPO,upaddPO,true);
      }
      return XfR.ok(addPOServiceImpl.updateById(upaddPO));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/addpos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(addPOServiceImpl.removeById(id));
  }

  @PostMapping("/addpos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "add_p_o");
     params.put("request", condition);

     return XfR.ok(addPOServiceImpl.querys(params));
  }

}
