package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.NoticeBillHandleRecord;
import com.xforceplus.ultraman.app.jctke.service.INoticeBillHandleRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-03
 */
@RestController
public class NoticeBillHandleRecordController {

  @Autowired
  private INoticeBillHandleRecordService noticeBillHandleRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param noticeBillHandleRecord ${table.comment}
   * @return
   */
  @GetMapping("/noticebillhandlerecords" )
  public XfR getNoticeBillHandleRecords(XfPage page, NoticeBillHandleRecord noticeBillHandleRecord) {
    return XfR.ok(noticeBillHandleRecordServiceImpl.page(page, Wrappers.query(noticeBillHandleRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/noticebillhandlerecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(noticeBillHandleRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param noticeBillHandleRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/noticebillhandlerecords")
  public XfR save(@RequestBody NoticeBillHandleRecord noticeBillHandleRecord) {
     return XfR.ok(noticeBillHandleRecordServiceImpl.save(noticeBillHandleRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param noticeBillHandleRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/noticebillhandlerecords/{id}")
  public XfR putUpdate(@RequestBody NoticeBillHandleRecord noticeBillHandleRecord,@PathVariable Long id) {
      noticeBillHandleRecord.setId(id);
      return XfR.ok(noticeBillHandleRecordServiceImpl.updateById(noticeBillHandleRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param noticeBillHandleRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/noticebillhandlerecords/{id}")
  public XfR patchUpdate(@RequestBody NoticeBillHandleRecord noticeBillHandleRecord,@PathVariable Long id) {
      NoticeBillHandleRecord upnoticeBillHandleRecord = noticeBillHandleRecordServiceImpl.getById(id);
      if(upnoticeBillHandleRecord != null){
        upnoticeBillHandleRecord = ObjectCopyUtils.copyProperties(noticeBillHandleRecord,upnoticeBillHandleRecord,true);
      }
      return XfR.ok(noticeBillHandleRecordServiceImpl.updateById(upnoticeBillHandleRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/noticebillhandlerecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(noticeBillHandleRecordServiceImpl.removeById(id));
  }

  @PostMapping("/noticebillhandlerecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "notice_bill_handle_record");
     params.put("request", condition);

     return XfR.ok(noticeBillHandleRecordServiceImpl.querys(params));
  }

}
