package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.AutoGoodsRecode;
import com.xforceplus.ultraman.app.jctke.service.IAutoGoodsRecodeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-17
 */
@RestController
public class AutoGoodsRecodeController {

  @Autowired
  private IAutoGoodsRecodeService autoGoodsRecodeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autoGoodsRecode ${table.comment}
   * @return
   */
  @GetMapping("/autogoodsrecodes" )
  public XfR getAutoGoodsRecodes(XfPage page, AutoGoodsRecode autoGoodsRecode) {
    return XfR.ok(autoGoodsRecodeServiceImpl.page(page, Wrappers.query(autoGoodsRecode)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/autogoodsrecodes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autoGoodsRecodeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param autoGoodsRecode ${table.comment}
   * @return XfR
   */
  @PostMapping("/autogoodsrecodes")
  public XfR save(@RequestBody AutoGoodsRecode autoGoodsRecode) {
     return XfR.ok(autoGoodsRecodeServiceImpl.save(autoGoodsRecode));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param autoGoodsRecode ${table.comment}
   * @return XfR
   */
  @PutMapping("/autogoodsrecodes/{id}")
  public XfR putUpdate(@RequestBody AutoGoodsRecode autoGoodsRecode,@PathVariable Long id) {
      autoGoodsRecode.setId(id);
      return XfR.ok(autoGoodsRecodeServiceImpl.updateById(autoGoodsRecode));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param autoGoodsRecode ${table.comment}
   * @return XfR
   */
  @PatchMapping("/autogoodsrecodes/{id}")
  public XfR patchUpdate(@RequestBody AutoGoodsRecode autoGoodsRecode,@PathVariable Long id) {
      AutoGoodsRecode upautoGoodsRecode = autoGoodsRecodeServiceImpl.getById(id);
      if(upautoGoodsRecode != null){
        upautoGoodsRecode = ObjectCopyUtils.copyProperties(autoGoodsRecode,upautoGoodsRecode,true);
      }
      return XfR.ok(autoGoodsRecodeServiceImpl.updateById(upautoGoodsRecode));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autogoodsrecodes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autoGoodsRecodeServiceImpl.removeById(id));
  }

  @PostMapping("/autogoodsrecodes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "auto_goods_recode");
     params.put("request", condition);

     return XfR.ok(autoGoodsRecodeServiceImpl.querys(params));
  }

}
