package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.Invoice;
import com.xforceplus.ultraman.app.jctke.service.IInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 发票主信息#含增税和非税发票前端控制器
 *
 * @author ultraman
 * @date 2023-04-17
 */
@RestController
public class InvoiceController {

  @Autowired
  private IInvoiceService invoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoice 发票主信息#含增税和非税发票
   * @return
   */
  @GetMapping("/invoices" )
  public XfR getInvoices(XfPage page, Invoice invoice) {
    return XfR.ok(invoiceServiceImpl.page(page, Wrappers.query(invoice)));
  }

  /**
   * 通过id查询发票主信息#含增税和非税发票
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceServiceImpl.getById(id));
  }

  /**
   * 新增发票主信息#含增税和非税发票
   * @param invoice 发票主信息#含增税和非税发票
   * @return XfR
   */
  @PostMapping("/invoices")
  public XfR save(@RequestBody Invoice invoice) {
     return XfR.ok(invoiceServiceImpl.save(invoice));
  }

  /**
   * 修改-传入修改后的全部数据发票主信息#含增税和非税发票
   * @param invoice 发票主信息#含增税和非税发票
   * @return XfR
   */
  @PutMapping("/invoices/{id}")
  public XfR putUpdate(@RequestBody Invoice invoice,@PathVariable Long id) {
      invoice.setId(id);
      return XfR.ok(invoiceServiceImpl.updateById(invoice));
  }

  /**
   * 修改-传入修改的数据发票主信息#含增税和非税发票
   * @param invoice 发票主信息#含增税和非税发票
   * @return XfR
   */
  @PatchMapping("/invoices/{id}")
  public XfR patchUpdate(@RequestBody Invoice invoice,@PathVariable Long id) {
      Invoice upinvoice = invoiceServiceImpl.getById(id);
      if(upinvoice != null){
        upinvoice = ObjectCopyUtils.copyProperties(invoice,upinvoice,true);
      }
      return XfR.ok(invoiceServiceImpl.updateById(upinvoice));
  }

  /**
   * 通过id删除发票主信息#含增税和非税发票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceServiceImpl.removeById(id));
  }

  @PostMapping("/invoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice");
     params.put("request", condition);

     return XfR.ok(invoiceServiceImpl.querys(params));
  }

}
