package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.ApprovalTemplate;
import com.xforceplus.ultraman.app.jctke.service.IApprovalTemplateService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-31
 */
@RestController
public class ApprovalTemplateController {

  @Autowired
  private IApprovalTemplateService approvalTemplateServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param approvalTemplate ${table.comment}
   * @return
   */
  @GetMapping("/approvaltemplates" )
  public XfR getApprovalTemplates(XfPage page, ApprovalTemplate approvalTemplate) {
    return XfR.ok(approvalTemplateServiceImpl.page(page, Wrappers.query(approvalTemplate)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/approvaltemplates/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(approvalTemplateServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param approvalTemplate ${table.comment}
   * @return XfR
   */
  @PostMapping("/approvaltemplates")
  public XfR save(@RequestBody ApprovalTemplate approvalTemplate) {
     return XfR.ok(approvalTemplateServiceImpl.save(approvalTemplate));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param approvalTemplate ${table.comment}
   * @return XfR
   */
  @PutMapping("/approvaltemplates/{id}")
  public XfR putUpdate(@RequestBody ApprovalTemplate approvalTemplate,@PathVariable Long id) {
      approvalTemplate.setId(id);
      return XfR.ok(approvalTemplateServiceImpl.updateById(approvalTemplate));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param approvalTemplate ${table.comment}
   * @return XfR
   */
  @PatchMapping("/approvaltemplates/{id}")
  public XfR patchUpdate(@RequestBody ApprovalTemplate approvalTemplate,@PathVariable Long id) {
      ApprovalTemplate upapprovalTemplate = approvalTemplateServiceImpl.getById(id);
      if(upapprovalTemplate != null){
        upapprovalTemplate = ObjectCopyUtils.copyProperties(approvalTemplate,upapprovalTemplate,true);
      }
      return XfR.ok(approvalTemplateServiceImpl.updateById(upapprovalTemplate));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/approvaltemplates/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(approvalTemplateServiceImpl.removeById(id));
  }

  @PostMapping("/approvaltemplates/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "approval_template");
     params.put("request", condition);

     return XfR.ok(approvalTemplateServiceImpl.querys(params));
  }

}
