package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.CodeGenerator;
import com.xforceplus.ultraman.app.jctke.service.ICodeGeneratorService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-31
 */
@RestController
public class CodeGeneratorController {

  @Autowired
  private ICodeGeneratorService codeGeneratorServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param codeGenerator ${table.comment}
   * @return
   */
  @GetMapping("/codegenerators" )
  public XfR getCodeGenerators(XfPage page, CodeGenerator codeGenerator) {
    return XfR.ok(codeGeneratorServiceImpl.page(page, Wrappers.query(codeGenerator)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/codegenerators/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(codeGeneratorServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param codeGenerator ${table.comment}
   * @return XfR
   */
  @PostMapping("/codegenerators")
  public XfR save(@RequestBody CodeGenerator codeGenerator) {
     return XfR.ok(codeGeneratorServiceImpl.save(codeGenerator));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param codeGenerator ${table.comment}
   * @return XfR
   */
  @PutMapping("/codegenerators/{id}")
  public XfR putUpdate(@RequestBody CodeGenerator codeGenerator,@PathVariable Long id) {
      codeGenerator.setId(id);
      return XfR.ok(codeGeneratorServiceImpl.updateById(codeGenerator));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param codeGenerator ${table.comment}
   * @return XfR
   */
  @PatchMapping("/codegenerators/{id}")
  public XfR patchUpdate(@RequestBody CodeGenerator codeGenerator,@PathVariable Long id) {
      CodeGenerator upcodeGenerator = codeGeneratorServiceImpl.getById(id);
      if(upcodeGenerator != null){
        upcodeGenerator = ObjectCopyUtils.copyProperties(codeGenerator,upcodeGenerator,true);
      }
      return XfR.ok(codeGeneratorServiceImpl.updateById(upcodeGenerator));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/codegenerators/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(codeGeneratorServiceImpl.removeById(id));
  }

  @PostMapping("/codegenerators/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "code_generator");
     params.put("request", condition);

     return XfR.ok(codeGeneratorServiceImpl.querys(params));
  }

}
