package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.Enclosure;
import com.xforceplus.ultraman.app.jctke.service.IEnclosureService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-31
 */
@RestController
public class EnclosureController {

  @Autowired
  private IEnclosureService enclosureServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param enclosure ${table.comment}
   * @return
   */
  @GetMapping("/enclosures" )
  public XfR getEnclosures(XfPage page, Enclosure enclosure) {
    return XfR.ok(enclosureServiceImpl.page(page, Wrappers.query(enclosure)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/enclosures/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(enclosureServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param enclosure ${table.comment}
   * @return XfR
   */
  @PostMapping("/enclosures")
  public XfR save(@RequestBody Enclosure enclosure) {
     return XfR.ok(enclosureServiceImpl.save(enclosure));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param enclosure ${table.comment}
   * @return XfR
   */
  @PutMapping("/enclosures/{id}")
  public XfR putUpdate(@RequestBody Enclosure enclosure,@PathVariable Long id) {
      enclosure.setId(id);
      return XfR.ok(enclosureServiceImpl.updateById(enclosure));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param enclosure ${table.comment}
   * @return XfR
   */
  @PatchMapping("/enclosures/{id}")
  public XfR patchUpdate(@RequestBody Enclosure enclosure,@PathVariable Long id) {
      Enclosure upenclosure = enclosureServiceImpl.getById(id);
      if(upenclosure != null){
        upenclosure = ObjectCopyUtils.copyProperties(enclosure,upenclosure,true);
      }
      return XfR.ok(enclosureServiceImpl.updateById(upenclosure));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/enclosures/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(enclosureServiceImpl.removeById(id));
  }

  @PostMapping("/enclosures/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "enclosure");
     params.put("request", condition);

     return XfR.ok(enclosureServiceImpl.querys(params));
  }

}
