package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.AgentPaymentTermInitFailedHistory;
import com.xforceplus.ultraman.app.jctke.service.IAgentPaymentTermInitFailedHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 前端控制器
 *
 * @author ultraman
 * @date 2023-06-02
 */
@RestController
public class AgentPaymentTermInitFailedHistoryController {

  @Autowired
  private IAgentPaymentTermInitFailedHistoryService agentPaymentTermInitFailedHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param agentPaymentTermInitFailedHistory 
   * @return
   */
  @GetMapping("/agentpaymentterminitfailedhistorys" )
  public XfR getAgentPaymentTermInitFailedHistorys(XfPage page, AgentPaymentTermInitFailedHistory agentPaymentTermInitFailedHistory) {
    return XfR.ok(agentPaymentTermInitFailedHistoryServiceImpl.page(page, Wrappers.query(agentPaymentTermInitFailedHistory)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/agentpaymentterminitfailedhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(agentPaymentTermInitFailedHistoryServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param agentPaymentTermInitFailedHistory 
   * @return XfR
   */
  @PostMapping("/agentpaymentterminitfailedhistorys")
  public XfR save(@RequestBody AgentPaymentTermInitFailedHistory agentPaymentTermInitFailedHistory) {
     return XfR.ok(agentPaymentTermInitFailedHistoryServiceImpl.save(agentPaymentTermInitFailedHistory));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param agentPaymentTermInitFailedHistory 
   * @return XfR
   */
  @PutMapping("/agentpaymentterminitfailedhistorys/{id}")
  public XfR putUpdate(@RequestBody AgentPaymentTermInitFailedHistory agentPaymentTermInitFailedHistory,@PathVariable Long id) {
      agentPaymentTermInitFailedHistory.setId(id);
      return XfR.ok(agentPaymentTermInitFailedHistoryServiceImpl.updateById(agentPaymentTermInitFailedHistory));
  }

  /**
   * 修改-传入修改的数据
   * @param agentPaymentTermInitFailedHistory 
   * @return XfR
   */
  @PatchMapping("/agentpaymentterminitfailedhistorys/{id}")
  public XfR patchUpdate(@RequestBody AgentPaymentTermInitFailedHistory agentPaymentTermInitFailedHistory,@PathVariable Long id) {
      AgentPaymentTermInitFailedHistory upagentPaymentTermInitFailedHistory = agentPaymentTermInitFailedHistoryServiceImpl.getById(id);
      if(upagentPaymentTermInitFailedHistory != null){
        upagentPaymentTermInitFailedHistory = ObjectCopyUtils.copyProperties(agentPaymentTermInitFailedHistory,upagentPaymentTermInitFailedHistory,true);
      }
      return XfR.ok(agentPaymentTermInitFailedHistoryServiceImpl.updateById(upagentPaymentTermInitFailedHistory));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/agentpaymentterminitfailedhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(agentPaymentTermInitFailedHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/agentpaymentterminitfailedhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "agent_payment_term_init_failed_history");
     params.put("request", condition);

     return XfR.ok(agentPaymentTermInitFailedHistoryServiceImpl.querys(params));
  }

}
