package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.InvoiceNoticeBillItem;
import com.xforceplus.ultraman.app.jctke.service.IInvoiceNoticeBillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 前端控制器
 *
 * @author ultraman
 * @date 2023-06-02
 */
@RestController
public class InvoiceNoticeBillItemController {

  @Autowired
  private IInvoiceNoticeBillItemService invoiceNoticeBillItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceNoticeBillItem 
   * @return
   */
  @GetMapping("/invoicenoticebillitems" )
  public XfR getInvoiceNoticeBillItems(XfPage page, InvoiceNoticeBillItem invoiceNoticeBillItem) {
    return XfR.ok(invoiceNoticeBillItemServiceImpl.page(page, Wrappers.query(invoiceNoticeBillItem)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicenoticebillitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceNoticeBillItemServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param invoiceNoticeBillItem 
   * @return XfR
   */
  @PostMapping("/invoicenoticebillitems")
  public XfR save(@RequestBody InvoiceNoticeBillItem invoiceNoticeBillItem) {
     return XfR.ok(invoiceNoticeBillItemServiceImpl.save(invoiceNoticeBillItem));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param invoiceNoticeBillItem 
   * @return XfR
   */
  @PutMapping("/invoicenoticebillitems/{id}")
  public XfR putUpdate(@RequestBody InvoiceNoticeBillItem invoiceNoticeBillItem,@PathVariable Long id) {
      invoiceNoticeBillItem.setId(id);
      return XfR.ok(invoiceNoticeBillItemServiceImpl.updateById(invoiceNoticeBillItem));
  }

  /**
   * 修改-传入修改的数据
   * @param invoiceNoticeBillItem 
   * @return XfR
   */
  @PatchMapping("/invoicenoticebillitems/{id}")
  public XfR patchUpdate(@RequestBody InvoiceNoticeBillItem invoiceNoticeBillItem,@PathVariable Long id) {
      InvoiceNoticeBillItem upinvoiceNoticeBillItem = invoiceNoticeBillItemServiceImpl.getById(id);
      if(upinvoiceNoticeBillItem != null){
        upinvoiceNoticeBillItem = ObjectCopyUtils.copyProperties(invoiceNoticeBillItem,upinvoiceNoticeBillItem,true);
      }
      return XfR.ok(invoiceNoticeBillItemServiceImpl.updateById(upinvoiceNoticeBillItem));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicenoticebillitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceNoticeBillItemServiceImpl.removeById(id));
  }

  @PostMapping("/invoicenoticebillitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_notice_bill_item");
     params.put("request", condition);

     return XfR.ok(invoiceNoticeBillItemServiceImpl.querys(params));
  }

}
