package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.Wbs;
import com.xforceplus.ultraman.app.jctke.service.IWbsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-02
 */
@RestController
public class WbsController {

  @Autowired
  private IWbsService wbsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param wbs ${table.comment}
   * @return
   */
  @GetMapping("/wbss" )
  public XfR getWbss(XfPage page, Wbs wbs) {
    return XfR.ok(wbsServiceImpl.page(page, Wrappers.query(wbs)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/wbss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(wbsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param wbs ${table.comment}
   * @return XfR
   */
  @PostMapping("/wbss")
  public XfR save(@RequestBody Wbs wbs) {
     return XfR.ok(wbsServiceImpl.save(wbs));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param wbs ${table.comment}
   * @return XfR
   */
  @PutMapping("/wbss/{id}")
  public XfR putUpdate(@RequestBody Wbs wbs,@PathVariable Long id) {
      wbs.setId(id);
      return XfR.ok(wbsServiceImpl.updateById(wbs));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param wbs ${table.comment}
   * @return XfR
   */
  @PatchMapping("/wbss/{id}")
  public XfR patchUpdate(@RequestBody Wbs wbs,@PathVariable Long id) {
      Wbs upwbs = wbsServiceImpl.getById(id);
      if(upwbs != null){
        upwbs = ObjectCopyUtils.copyProperties(wbs,upwbs,true);
      }
      return XfR.ok(wbsServiceImpl.updateById(upwbs));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/wbss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(wbsServiceImpl.removeById(id));
  }

  @PostMapping("/wbss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "wbs");
     params.put("request", condition);

     return XfR.ok(wbsServiceImpl.querys(params));
  }

}
