package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.DispatcherRuleConfig;
import com.xforceplus.ultraman.app.jctke.service.IDispatcherRuleConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-23
 */
@RestController
public class DispatcherRuleConfigController {

  @Autowired
  private IDispatcherRuleConfigService dispatcherRuleConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dispatcherRuleConfig ${table.comment}
   * @return
   */
  @GetMapping("/dispatcherruleconfigs" )
  public XfR getDispatcherRuleConfigs(XfPage page, DispatcherRuleConfig dispatcherRuleConfig) {
    return XfR.ok(dispatcherRuleConfigServiceImpl.page(page, Wrappers.query(dispatcherRuleConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/dispatcherruleconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dispatcherRuleConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param dispatcherRuleConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/dispatcherruleconfigs")
  public XfR save(@RequestBody DispatcherRuleConfig dispatcherRuleConfig) {
     return XfR.ok(dispatcherRuleConfigServiceImpl.save(dispatcherRuleConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param dispatcherRuleConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/dispatcherruleconfigs/{id}")
  public XfR putUpdate(@RequestBody DispatcherRuleConfig dispatcherRuleConfig,@PathVariable Long id) {
      dispatcherRuleConfig.setId(id);
      return XfR.ok(dispatcherRuleConfigServiceImpl.updateById(dispatcherRuleConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param dispatcherRuleConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/dispatcherruleconfigs/{id}")
  public XfR patchUpdate(@RequestBody DispatcherRuleConfig dispatcherRuleConfig,@PathVariable Long id) {
      DispatcherRuleConfig updispatcherRuleConfig = dispatcherRuleConfigServiceImpl.getById(id);
      if(updispatcherRuleConfig != null){
        updispatcherRuleConfig = ObjectCopyUtils.copyProperties(dispatcherRuleConfig,updispatcherRuleConfig,true);
      }
      return XfR.ok(dispatcherRuleConfigServiceImpl.updateById(updispatcherRuleConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dispatcherruleconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dispatcherRuleConfigServiceImpl.removeById(id));
  }

  @PostMapping("/dispatcherruleconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dispatcher_rule_config");
     params.put("request", condition);

     return XfR.ok(dispatcherRuleConfigServiceImpl.querys(params));
  }

}
