package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.PurchaseOrderOperationLog;
import com.xforceplus.ultraman.app.jctke.service.IPurchaseOrderOperationLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-23
 */
@RestController
public class PurchaseOrderOperationLogController {

  @Autowired
  private IPurchaseOrderOperationLogService purchaseOrderOperationLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaseOrderOperationLog ${table.comment}
   * @return
   */
  @GetMapping("/purchaseorderoperationlogs" )
  public XfR getPurchaseOrderOperationLogs(XfPage page, PurchaseOrderOperationLog purchaseOrderOperationLog) {
    return XfR.ok(purchaseOrderOperationLogServiceImpl.page(page, Wrappers.query(purchaseOrderOperationLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaseorderoperationlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaseOrderOperationLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param purchaseOrderOperationLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/purchaseorderoperationlogs")
  public XfR save(@RequestBody PurchaseOrderOperationLog purchaseOrderOperationLog) {
     return XfR.ok(purchaseOrderOperationLogServiceImpl.save(purchaseOrderOperationLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param purchaseOrderOperationLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/purchaseorderoperationlogs/{id}")
  public XfR putUpdate(@RequestBody PurchaseOrderOperationLog purchaseOrderOperationLog,@PathVariable Long id) {
      purchaseOrderOperationLog.setId(id);
      return XfR.ok(purchaseOrderOperationLogServiceImpl.updateById(purchaseOrderOperationLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param purchaseOrderOperationLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/purchaseorderoperationlogs/{id}")
  public XfR patchUpdate(@RequestBody PurchaseOrderOperationLog purchaseOrderOperationLog,@PathVariable Long id) {
      PurchaseOrderOperationLog uppurchaseOrderOperationLog = purchaseOrderOperationLogServiceImpl.getById(id);
      if(uppurchaseOrderOperationLog != null){
        uppurchaseOrderOperationLog = ObjectCopyUtils.copyProperties(purchaseOrderOperationLog,uppurchaseOrderOperationLog,true);
      }
      return XfR.ok(purchaseOrderOperationLogServiceImpl.updateById(uppurchaseOrderOperationLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaseorderoperationlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaseOrderOperationLogServiceImpl.removeById(id));
  }

  @PostMapping("/purchaseorderoperationlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchase_order_operation_log");
     params.put("request", condition);

     return XfR.ok(purchaseOrderOperationLogServiceImpl.querys(params));
  }

}
