package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.Settlement;
import com.xforceplus.ultraman.app.jctke.service.ISettlementService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 结算单主信息前端控制器
 *
 * @author ultraman
 * @date 2024-01-23
 */
@RestController
public class SettlementController {

  @Autowired
  private ISettlementService settlementServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlement 结算单主信息
   * @return
   */
  @GetMapping("/settlements" )
  public XfR getSettlements(XfPage page, Settlement settlement) {
    return XfR.ok(settlementServiceImpl.page(page, Wrappers.query(settlement)));
  }

  /**
   * 通过id查询结算单主信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlements/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementServiceImpl.getById(id));
  }

  /**
   * 新增结算单主信息
   * @param settlement 结算单主信息
   * @return XfR
   */
  @PostMapping("/settlements")
  public XfR save(@RequestBody Settlement settlement) {
     return XfR.ok(settlementServiceImpl.save(settlement));
  }

  /**
   * 修改-传入修改后的全部数据结算单主信息
   * @param settlement 结算单主信息
   * @return XfR
   */
  @PutMapping("/settlements/{id}")
  public XfR putUpdate(@RequestBody Settlement settlement,@PathVariable Long id) {
      settlement.setId(id);
      return XfR.ok(settlementServiceImpl.updateById(settlement));
  }

  /**
   * 修改-传入修改的数据结算单主信息
   * @param settlement 结算单主信息
   * @return XfR
   */
  @PatchMapping("/settlements/{id}")
  public XfR patchUpdate(@RequestBody Settlement settlement,@PathVariable Long id) {
      Settlement upsettlement = settlementServiceImpl.getById(id);
      if(upsettlement != null){
        upsettlement = ObjectCopyUtils.copyProperties(settlement,upsettlement,true);
      }
      return XfR.ok(settlementServiceImpl.updateById(upsettlement));
  }

  /**
   * 通过id删除结算单主信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlements/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementServiceImpl.removeById(id));
  }

  @PostMapping("/settlements/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement");
     params.put("request", condition);

     return XfR.ok(settlementServiceImpl.querys(params));
  }

}
