/*
 *    Copyright (c) 2020-2027, wangzheng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the pig4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: wangzheng (wangzheng@xforceplus.com)
 */

package com.xforceplus.ultraman.app.jctke.service.impl;

import com.xforceplus.ultraman.app.jctke.entity.UltramanSysBoUserSetting;
import com.xforceplus.ultraman.app.jctke.mapper.UltramanSysBoUserSettingMapper;
import com.xforceplus.ultraman.app.jctke.service.IUltramanSysBoUserSettingService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.ultraman.bocp.gen.annotation.BoService;
import org.springframework.stereotype.Service;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Optional;
import java.io.Serializable;
import java.util.stream.Collectors;
import java.util.function.Function;

import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

/**
 * <p>
 * 页面用户自定义配置 服务实现类
 * </p>
 *
 * @author ultraman
 * @since 2024-01-23
 */
@BoService(value = "1664469185032925185")
@Service
public class UltramanSysBoUserSettingServiceImpl extends ServiceImpl<UltramanSysBoUserSettingMapper, UltramanSysBoUserSetting> implements IUltramanSysBoUserSettingService {

    @Override
    public List<Map> querys(Map<String, Object> params) {
        ConditionQueryRequest req = (ConditionQueryRequest) params.get("request");
        List<Map> result = this.baseMapper.querys(params);
        result.stream().forEach(rs ->
            req.getEntity().getEntities().stream()
            .filter(entity -> rs.containsKey(entity.getCode()))
            .forEach(entity -> {
                Map entityRs = (HashMap) rs.get(entity.getCode());
                entityRs.keySet().stream().forEach(key ->
                    rs.put(entity.getCode() + "." + key, entityRs.get(key))
                );
                rs.remove(entity.getCode());
            })
        );
        return result;
    }
}
