package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.WbsInitFaieledHistory;
import com.xforceplus.ultraman.app.jctke.service.IWbsInitFaieledHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-07
 */
@RestController
public class WbsInitFaieledHistoryController {

  @Autowired
  private IWbsInitFaieledHistoryService wbsInitFaieledHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param wbsInitFaieledHistory ${table.comment}
   * @return
   */
  @GetMapping("/wbsinitfaieledhistorys" )
  public XfR getWbsInitFaieledHistorys(XfPage page, WbsInitFaieledHistory wbsInitFaieledHistory) {
    return XfR.ok(wbsInitFaieledHistoryServiceImpl.page(page, Wrappers.query(wbsInitFaieledHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/wbsinitfaieledhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(wbsInitFaieledHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param wbsInitFaieledHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/wbsinitfaieledhistorys")
  public XfR save(@RequestBody WbsInitFaieledHistory wbsInitFaieledHistory) {
     return XfR.ok(wbsInitFaieledHistoryServiceImpl.save(wbsInitFaieledHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param wbsInitFaieledHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/wbsinitfaieledhistorys/{id}")
  public XfR putUpdate(@RequestBody WbsInitFaieledHistory wbsInitFaieledHistory,@PathVariable Long id) {
      wbsInitFaieledHistory.setId(id);
      return XfR.ok(wbsInitFaieledHistoryServiceImpl.updateById(wbsInitFaieledHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param wbsInitFaieledHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/wbsinitfaieledhistorys/{id}")
  public XfR patchUpdate(@RequestBody WbsInitFaieledHistory wbsInitFaieledHistory,@PathVariable Long id) {
      WbsInitFaieledHistory upwbsInitFaieledHistory = wbsInitFaieledHistoryServiceImpl.getById(id);
      if(upwbsInitFaieledHistory != null){
        upwbsInitFaieledHistory = ObjectCopyUtils.copyProperties(wbsInitFaieledHistory,upwbsInitFaieledHistory,true);
      }
      return XfR.ok(wbsInitFaieledHistoryServiceImpl.updateById(upwbsInitFaieledHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/wbsinitfaieledhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(wbsInitFaieledHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/wbsinitfaieledhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "wbs_init_faieled_history");
     params.put("request", condition);

     return XfR.ok(wbsInitFaieledHistoryServiceImpl.querys(params));
  }

}
