package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.WorkPlan;
import com.xforceplus.ultraman.app.jctke.service.IWorkPlanService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-07
 */
@RestController
public class WorkPlanController {

  @Autowired
  private IWorkPlanService workPlanServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param workPlan ${table.comment}
   * @return
   */
  @GetMapping("/workplans" )
  public XfR getWorkPlans(XfPage page, WorkPlan workPlan) {
    return XfR.ok(workPlanServiceImpl.page(page, Wrappers.query(workPlan)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/workplans/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(workPlanServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param workPlan ${table.comment}
   * @return XfR
   */
  @PostMapping("/workplans")
  public XfR save(@RequestBody WorkPlan workPlan) {
     return XfR.ok(workPlanServiceImpl.save(workPlan));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param workPlan ${table.comment}
   * @return XfR
   */
  @PutMapping("/workplans/{id}")
  public XfR putUpdate(@RequestBody WorkPlan workPlan,@PathVariable Long id) {
      workPlan.setId(id);
      return XfR.ok(workPlanServiceImpl.updateById(workPlan));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param workPlan ${table.comment}
   * @return XfR
   */
  @PatchMapping("/workplans/{id}")
  public XfR patchUpdate(@RequestBody WorkPlan workPlan,@PathVariable Long id) {
      WorkPlan upworkPlan = workPlanServiceImpl.getById(id);
      if(upworkPlan != null){
        upworkPlan = ObjectCopyUtils.copyProperties(workPlan,upworkPlan,true);
      }
      return XfR.ok(workPlanServiceImpl.updateById(upworkPlan));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/workplans/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(workPlanServiceImpl.removeById(id));
  }

  @PostMapping("/workplans/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "work_plan");
     params.put("request", condition);

     return XfR.ok(workPlanServiceImpl.querys(params));
  }

}
