package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.ClosingDate;
import com.xforceplus.ultraman.app.jctke.service.IClosingDateService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-01
 */
@RestController
public class ClosingDateController {

  @Autowired
  private IClosingDateService closingDateServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param closingDate ${table.comment}
   * @return
   */
  @GetMapping("/closingdates" )
  public XfR getClosingDates(XfPage page, ClosingDate closingDate) {
    return XfR.ok(closingDateServiceImpl.page(page, Wrappers.query(closingDate)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/closingdates/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(closingDateServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param closingDate ${table.comment}
   * @return XfR
   */
  @PostMapping("/closingdates")
  public XfR save(@RequestBody ClosingDate closingDate) {
     return XfR.ok(closingDateServiceImpl.save(closingDate));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param closingDate ${table.comment}
   * @return XfR
   */
  @PutMapping("/closingdates/{id}")
  public XfR putUpdate(@RequestBody ClosingDate closingDate,@PathVariable Long id) {
      closingDate.setId(id);
      return XfR.ok(closingDateServiceImpl.updateById(closingDate));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param closingDate ${table.comment}
   * @return XfR
   */
  @PatchMapping("/closingdates/{id}")
  public XfR patchUpdate(@RequestBody ClosingDate closingDate,@PathVariable Long id) {
      ClosingDate upclosingDate = closingDateServiceImpl.getById(id);
      if(upclosingDate != null){
        upclosingDate = ObjectCopyUtils.copyProperties(closingDate,upclosingDate,true);
      }
      return XfR.ok(closingDateServiceImpl.updateById(upclosingDate));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/closingdates/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(closingDateServiceImpl.removeById(id));
  }

  @PostMapping("/closingdates/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "closing_date");
     params.put("request", condition);

     return XfR.ok(closingDateServiceImpl.querys(params));
  }

}
