package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.DataMirgrationRecord;
import com.xforceplus.ultraman.app.jctke.service.IDataMirgrationRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 付款数据补录履历前端控制器
 *
 * @author ultraman
 * @date 2024-07-01
 */
@RestController
public class DataMirgrationRecordController {

  @Autowired
  private IDataMirgrationRecordService dataMirgrationRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dataMirgrationRecord 付款数据补录履历
   * @return
   */
  @GetMapping("/datamirgrationrecords" )
  public XfR getDataMirgrationRecords(XfPage page, DataMirgrationRecord dataMirgrationRecord) {
    return XfR.ok(dataMirgrationRecordServiceImpl.page(page, Wrappers.query(dataMirgrationRecord)));
  }

  /**
   * 通过id查询付款数据补录履历
   * @param  id
   * @return XfR
   */
  @GetMapping("/datamirgrationrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dataMirgrationRecordServiceImpl.getById(id));
  }

  /**
   * 新增付款数据补录履历
   * @param dataMirgrationRecord 付款数据补录履历
   * @return XfR
   */
  @PostMapping("/datamirgrationrecords")
  public XfR save(@RequestBody DataMirgrationRecord dataMirgrationRecord) {
     return XfR.ok(dataMirgrationRecordServiceImpl.save(dataMirgrationRecord));
  }

  /**
   * 修改-传入修改后的全部数据付款数据补录履历
   * @param dataMirgrationRecord 付款数据补录履历
   * @return XfR
   */
  @PutMapping("/datamirgrationrecords/{id}")
  public XfR putUpdate(@RequestBody DataMirgrationRecord dataMirgrationRecord,@PathVariable Long id) {
      dataMirgrationRecord.setId(id);
      return XfR.ok(dataMirgrationRecordServiceImpl.updateById(dataMirgrationRecord));
  }

  /**
   * 修改-传入修改的数据付款数据补录履历
   * @param dataMirgrationRecord 付款数据补录履历
   * @return XfR
   */
  @PatchMapping("/datamirgrationrecords/{id}")
  public XfR patchUpdate(@RequestBody DataMirgrationRecord dataMirgrationRecord,@PathVariable Long id) {
      DataMirgrationRecord updataMirgrationRecord = dataMirgrationRecordServiceImpl.getById(id);
      if(updataMirgrationRecord != null){
        updataMirgrationRecord = ObjectCopyUtils.copyProperties(dataMirgrationRecord,updataMirgrationRecord,true);
      }
      return XfR.ok(dataMirgrationRecordServiceImpl.updateById(updataMirgrationRecord));
  }

  /**
   * 通过id删除付款数据补录履历
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/datamirgrationrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dataMirgrationRecordServiceImpl.removeById(id));
  }

  @PostMapping("/datamirgrationrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "data_mirgration_record");
     params.put("request", condition);

     return XfR.ok(dataMirgrationRecordServiceImpl.querys(params));
  }

}
