package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.InvoiceDataMirgrationRecord;
import com.xforceplus.ultraman.app.jctke.service.IInvoiceDataMirgrationRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-01
 */
@RestController
public class InvoiceDataMirgrationRecordController {

  @Autowired
  private IInvoiceDataMirgrationRecordService invoiceDataMirgrationRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceDataMirgrationRecord ${table.comment}
   * @return
   */
  @GetMapping("/invoicedatamirgrationrecords" )
  public XfR getInvoiceDataMirgrationRecords(XfPage page, InvoiceDataMirgrationRecord invoiceDataMirgrationRecord) {
    return XfR.ok(invoiceDataMirgrationRecordServiceImpl.page(page, Wrappers.query(invoiceDataMirgrationRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicedatamirgrationrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceDataMirgrationRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceDataMirgrationRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicedatamirgrationrecords")
  public XfR save(@RequestBody InvoiceDataMirgrationRecord invoiceDataMirgrationRecord) {
     return XfR.ok(invoiceDataMirgrationRecordServiceImpl.save(invoiceDataMirgrationRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceDataMirgrationRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicedatamirgrationrecords/{id}")
  public XfR putUpdate(@RequestBody InvoiceDataMirgrationRecord invoiceDataMirgrationRecord,@PathVariable Long id) {
      invoiceDataMirgrationRecord.setId(id);
      return XfR.ok(invoiceDataMirgrationRecordServiceImpl.updateById(invoiceDataMirgrationRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceDataMirgrationRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicedatamirgrationrecords/{id}")
  public XfR patchUpdate(@RequestBody InvoiceDataMirgrationRecord invoiceDataMirgrationRecord,@PathVariable Long id) {
      InvoiceDataMirgrationRecord upinvoiceDataMirgrationRecord = invoiceDataMirgrationRecordServiceImpl.getById(id);
      if(upinvoiceDataMirgrationRecord != null){
        upinvoiceDataMirgrationRecord = ObjectCopyUtils.copyProperties(invoiceDataMirgrationRecord,upinvoiceDataMirgrationRecord,true);
      }
      return XfR.ok(invoiceDataMirgrationRecordServiceImpl.updateById(upinvoiceDataMirgrationRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicedatamirgrationrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceDataMirgrationRecordServiceImpl.removeById(id));
  }

  @PostMapping("/invoicedatamirgrationrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_data_mirgration_record");
     params.put("request", condition);

     return XfR.ok(invoiceDataMirgrationRecordServiceImpl.querys(params));
  }

}
