package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.OrderHandleRecord;
import com.xforceplus.ultraman.app.jctke.service.IOrderHandleRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-01
 */
@RestController
public class OrderHandleRecordController {

  @Autowired
  private IOrderHandleRecordService orderHandleRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderHandleRecord ${table.comment}
   * @return
   */
  @GetMapping("/orderhandlerecords" )
  public XfR getOrderHandleRecords(XfPage page, OrderHandleRecord orderHandleRecord) {
    return XfR.ok(orderHandleRecordServiceImpl.page(page, Wrappers.query(orderHandleRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderhandlerecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderHandleRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderHandleRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderhandlerecords")
  public XfR save(@RequestBody OrderHandleRecord orderHandleRecord) {
     return XfR.ok(orderHandleRecordServiceImpl.save(orderHandleRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderHandleRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderhandlerecords/{id}")
  public XfR putUpdate(@RequestBody OrderHandleRecord orderHandleRecord,@PathVariable Long id) {
      orderHandleRecord.setId(id);
      return XfR.ok(orderHandleRecordServiceImpl.updateById(orderHandleRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderHandleRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderhandlerecords/{id}")
  public XfR patchUpdate(@RequestBody OrderHandleRecord orderHandleRecord,@PathVariable Long id) {
      OrderHandleRecord uporderHandleRecord = orderHandleRecordServiceImpl.getById(id);
      if(uporderHandleRecord != null){
        uporderHandleRecord = ObjectCopyUtils.copyProperties(orderHandleRecord,uporderHandleRecord,true);
      }
      return XfR.ok(orderHandleRecordServiceImpl.updateById(uporderHandleRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderhandlerecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderHandleRecordServiceImpl.removeById(id));
  }

  @PostMapping("/orderhandlerecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_handle_record");
     params.put("request", condition);

     return XfR.ok(orderHandleRecordServiceImpl.querys(params));
  }

}
