package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.PaymentManage;
import com.xforceplus.ultraman.app.jctke.service.IPaymentManageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 含预付单和应付单前端控制器
 *
 * @author ultraman
 * @date 2024-07-01
 */
@RestController
public class PaymentManageController {

  @Autowired
  private IPaymentManageService paymentManageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param paymentManage 含预付单和应付单
   * @return
   */
  @GetMapping("/paymentmanages" )
  public XfR getPaymentManages(XfPage page, PaymentManage paymentManage) {
    return XfR.ok(paymentManageServiceImpl.page(page, Wrappers.query(paymentManage)));
  }

  /**
   * 通过id查询含预付单和应付单
   * @param  id
   * @return XfR
   */
  @GetMapping("/paymentmanages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(paymentManageServiceImpl.getById(id));
  }

  /**
   * 新增含预付单和应付单
   * @param paymentManage 含预付单和应付单
   * @return XfR
   */
  @PostMapping("/paymentmanages")
  public XfR save(@RequestBody PaymentManage paymentManage) {
     return XfR.ok(paymentManageServiceImpl.save(paymentManage));
  }

  /**
   * 修改-传入修改后的全部数据含预付单和应付单
   * @param paymentManage 含预付单和应付单
   * @return XfR
   */
  @PutMapping("/paymentmanages/{id}")
  public XfR putUpdate(@RequestBody PaymentManage paymentManage,@PathVariable Long id) {
      paymentManage.setId(id);
      return XfR.ok(paymentManageServiceImpl.updateById(paymentManage));
  }

  /**
   * 修改-传入修改的数据含预付单和应付单
   * @param paymentManage 含预付单和应付单
   * @return XfR
   */
  @PatchMapping("/paymentmanages/{id}")
  public XfR patchUpdate(@RequestBody PaymentManage paymentManage,@PathVariable Long id) {
      PaymentManage uppaymentManage = paymentManageServiceImpl.getById(id);
      if(uppaymentManage != null){
        uppaymentManage = ObjectCopyUtils.copyProperties(paymentManage,uppaymentManage,true);
      }
      return XfR.ok(paymentManageServiceImpl.updateById(uppaymentManage));
  }

  /**
   * 通过id删除含预付单和应付单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/paymentmanages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(paymentManageServiceImpl.removeById(id));
  }

  @PostMapping("/paymentmanages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "payment_manage");
     params.put("request", condition);

     return XfR.ok(paymentManageServiceImpl.querys(params));
  }

}
