package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.WorkTodoSync;
import com.xforceplus.ultraman.app.jctke.service.IWorkTodoSyncService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-01
 */
@RestController
public class WorkTodoSyncController {

  @Autowired
  private IWorkTodoSyncService workTodoSyncServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param workTodoSync ${table.comment}
   * @return
   */
  @GetMapping("/worktodosyncs" )
  public XfR getWorkTodoSyncs(XfPage page, WorkTodoSync workTodoSync) {
    return XfR.ok(workTodoSyncServiceImpl.page(page, Wrappers.query(workTodoSync)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/worktodosyncs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(workTodoSyncServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param workTodoSync ${table.comment}
   * @return XfR
   */
  @PostMapping("/worktodosyncs")
  public XfR save(@RequestBody WorkTodoSync workTodoSync) {
     return XfR.ok(workTodoSyncServiceImpl.save(workTodoSync));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param workTodoSync ${table.comment}
   * @return XfR
   */
  @PutMapping("/worktodosyncs/{id}")
  public XfR putUpdate(@RequestBody WorkTodoSync workTodoSync,@PathVariable Long id) {
      workTodoSync.setId(id);
      return XfR.ok(workTodoSyncServiceImpl.updateById(workTodoSync));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param workTodoSync ${table.comment}
   * @return XfR
   */
  @PatchMapping("/worktodosyncs/{id}")
  public XfR patchUpdate(@RequestBody WorkTodoSync workTodoSync,@PathVariable Long id) {
      WorkTodoSync upworkTodoSync = workTodoSyncServiceImpl.getById(id);
      if(upworkTodoSync != null){
        upworkTodoSync = ObjectCopyUtils.copyProperties(workTodoSync,upworkTodoSync,true);
      }
      return XfR.ok(workTodoSyncServiceImpl.updateById(upworkTodoSync));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/worktodosyncs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(workTodoSyncServiceImpl.removeById(id));
  }

  @PostMapping("/worktodosyncs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "work_todo_sync");
     params.put("request", condition);

     return XfR.ok(workTodoSyncServiceImpl.querys(params));
  }

}
