package com.xforceplus.ultraman.app.jctraincuizheng2.controller;


/**
 * 测试字符串feign客户端
 *
 * @author ultraman
 * @date 2021-11-29
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctraincuizheng2.entity.Autotestzhifuchuan;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-train-cuizheng2")
public interface AutotestzhifuchuanFeignApi {

  /**
   * 通过id查询测试字符串
   * @param  id
   * @return R
   */
  @GetMapping("/autotestzhifuchuan/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增测试字符串
   * @param autotestzhifuchuan 测试字符串
   * @return R
   */
  @PostMapping("/autotestzhifuchuan/add")
  public R save(@RequestBody Autotestzhifuchuan autotestzhifuchuan);

  /**
   * 修改测试字符串
   * @param autotestzhifuchuan 测试字符串
   * @return R
   */
  @PostMapping("/autotestzhifuchuan/update")
  public R updateById(@RequestBody Autotestzhifuchuan autotestzhifuchuan);

  /**
   * 通过id删除测试字符串
   * @param  id
   * @return R
   */
  @DeleteMapping("/autotestzhifuchuan/del/{id}" )
  public R removeById(@PathVariable Long id);

}