package com.xforceplus.ultraman.app.jctraincuizheng2.controller;


/**
 * test公式feign客户端
 *
 * @author ultraman
 * @date 2021-12-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctraincuizheng2.entity.Autotestgongshi;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-train-cuizheng2")
public interface AutotestgongshiFeignApi {

  /**
   * 通过id查询test公式
   * @param  id
   * @return R
   */
  @GetMapping("/autotestgongshi/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增test公式
   * @param autotestgongshi test公式
   * @return R
   */
  @PostMapping("/autotestgongshi/add")
  public R save(@RequestBody Autotestgongshi autotestgongshi);

  /**
   * 修改test公式
   * @param autotestgongshi test公式
   * @return R
   */
  @PostMapping("/autotestgongshi/update")
  public R updateById(@RequestBody Autotestgongshi autotestgongshi);

  /**
   * 通过id删除test公式
   * @param  id
   * @return R
   */
  @DeleteMapping("/autotestgongshi/del/{id}" )
  public R removeById(@PathVariable Long id);

}