package com.xforceplus.ultraman.app.jctraincuizheng2.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * autotestobjectcode2
 * </p>
 *
 * @author ultraman
 * @since 2021-12-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Autotestobjectcode2 implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 字符串1
   */
  private String zifuchuan1;
  /**
   * 字符串2
   */
  private String zifuchuan2;
  /**
   * 字符串集合1
   */
  private String zifuchuanjihe1;
  /**
   * 字符串集合2
   */
  private String zifuchuanjihe2;
  /**
   * 数字编号1
   */
  private Long shuzibianhao1;
  /**
   * 数字编号2
   */
  private Long shuzibianhao2;
  /**
   * 浮点型1
   */
  private BigDecimal fudianxing1;
  /**
   * 浮点型2
   */
  private BigDecimal fudianxing2;
  /**
   * 布尔值1
   */
  private Boolean buerzhi1;
  /**
   * 布尔值2
   */
  private Boolean buerzhi2;
  /**
   * 时间戳1
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime shijianchuo1;
  /**
   * 时间戳2
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime shijianchuo2;
  /**
   * 公式1
   */
  private String gongshi1;
  /**
   * 整型1
   */
  private Long zhengxing1;
  /**
   * 整型2
   */
  private Long zhengxing2;
  /**
   * 枚举1
   */
  private String meiju1;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zifuchuan1", zifuchuan1);
      map.put("zifuchuan2", zifuchuan2);
      map.put("zifuchuanjihe1", zifuchuanjihe1);
      map.put("zifuchuanjihe2", zifuchuanjihe2);
      map.put("shuzibianhao1", shuzibianhao1);
      map.put("shuzibianhao2", shuzibianhao2);
      map.put("fudianxing1", fudianxing1);
      map.put("fudianxing2", fudianxing2);
      map.put("buerzhi1", buerzhi1);
      map.put("buerzhi2", buerzhi2);
      map.put("shijianchuo1", BocpGenUtils.toTimestamp(shijianchuo1));
      map.put("shijianchuo2", BocpGenUtils.toTimestamp(shijianchuo2));
      map.put("gongshi1", gongshi1);
      map.put("zhengxing1", zhengxing1);
      map.put("zhengxing2", zhengxing2);
      map.put("meiju1", meiju1);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static Autotestobjectcode2 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Autotestobjectcode2 entity = new Autotestobjectcode2();

    if(map.containsKey("zifuchuan1")) {
      Object obj = map.get("zifuchuan1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZifuchuan1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zifuchuan2")) {
      Object obj = map.get("zifuchuan2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZifuchuan2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zifuchuanjihe1")) {
      Object obj = map.get("zifuchuanjihe1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZifuchuanjihe1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zifuchuanjihe2")) {
      Object obj = map.get("zifuchuanjihe2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZifuchuanjihe2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shuzibianhao1")) {
      Object obj = map.get("shuzibianhao1");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setShuzibianhao1((Long)obj);
        } else if(obj instanceof String) {
          entity.setShuzibianhao1(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setShuzibianhao1(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("shuzibianhao2")) {
      Object obj = map.get("shuzibianhao2");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setShuzibianhao2((Long)obj);
        } else if(obj instanceof String) {
          entity.setShuzibianhao2(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setShuzibianhao2(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("fudianxing1")) {
      Object obj = map.get("fudianxing1");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFudianxing1((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFudianxing1(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFudianxing1(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setFudianxing1(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFudianxing1(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("fudianxing2")) {
      Object obj = map.get("fudianxing2");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFudianxing2((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFudianxing2(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFudianxing2(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setFudianxing2(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFudianxing2(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buerzhi1")) {
      Object obj = map.get("buerzhi1");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBuerzhi1((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setBuerzhi1(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("buerzhi2")) {
      Object obj = map.get("buerzhi2");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBuerzhi2((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setBuerzhi2(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("shijianchuo1")) {
      Object obj = map.get("shijianchuo1");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setShijianchuo1(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setShijianchuo1((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setShijianchuo1(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setShijianchuo1(null);
      }
    }
    if(map.containsKey("shijianchuo2")) {
      Object obj = map.get("shijianchuo2");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setShijianchuo2(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setShijianchuo2((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setShijianchuo2(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setShijianchuo2(null);
      }
    }
    if(map.containsKey("gongshi1")) {
      Object obj = map.get("gongshi1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGongshi1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhengxing1")) {
      Object obj = map.get("zhengxing1");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZhengxing1((Long)obj);
        } else if(obj instanceof String) {
          entity.setZhengxing1(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setZhengxing1(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("zhengxing2")) {
      Object obj = map.get("zhengxing2");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZhengxing2((Long)obj);
        } else if(obj instanceof String) {
          entity.setZhengxing2(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setZhengxing2(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("meiju1")) {
      Object obj = map.get("meiju1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMeiju1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("zifuchuan1")) {
      Object obj = map.get("zifuchuan1");
      if(obj != null) {
        if(obj instanceof String){
            this.setZifuchuan1((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("zifuchuan2")) {
      Object obj = map.get("zifuchuan2");
      if(obj != null) {
        if(obj instanceof String){
            this.setZifuchuan2((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("zifuchuanjihe1")) {
      Object obj = map.get("zifuchuanjihe1");
      if(obj != null) {
        if(obj instanceof String){
            this.setZifuchuanjihe1((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("zifuchuanjihe2")) {
      Object obj = map.get("zifuchuanjihe2");
      if(obj != null) {
        if(obj instanceof String){
            this.setZifuchuanjihe2((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("shuzibianhao1")) {
      Object obj = map.get("shuzibianhao1");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setShuzibianhao1((Long)obj);
        } else if(obj instanceof String) {
            this.setShuzibianhao1(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setShuzibianhao1(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("shuzibianhao2")) {
      Object obj = map.get("shuzibianhao2");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setShuzibianhao2((Long)obj);
        } else if(obj instanceof String) {
            this.setShuzibianhao2(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setShuzibianhao2(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("fudianxing1")) {
      Object obj = map.get("fudianxing1");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setFudianxing1((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setFudianxing1(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setFudianxing1(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setFudianxing1(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setFudianxing1(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("fudianxing2")) {
      Object obj = map.get("fudianxing2");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setFudianxing2((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setFudianxing2(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setFudianxing2(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setFudianxing2(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setFudianxing2(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("buerzhi1")) {
      Object obj = map.get("buerzhi1");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setBuerzhi1((Boolean)obj);
        } else if(obj instanceof String) {
            this.setBuerzhi1(Boolean.valueOf((String)obj));
        }
      } else{
      }
   }
    if(map.containsKey("buerzhi2")) {
      Object obj = map.get("buerzhi2");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setBuerzhi2((Boolean)obj);
        } else if(obj instanceof String) {
            this.setBuerzhi2(Boolean.valueOf((String)obj));
        }
      } else{
      }
   }
    if(map.containsKey("shijianchuo1")) {
      Object obj = map.get("shijianchuo1");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setShijianchuo1(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setShijianchuo1((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setShijianchuo1(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setShijianchuo1(null);
      }
   }
    if(map.containsKey("shijianchuo2")) {
      Object obj = map.get("shijianchuo2");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setShijianchuo2(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setShijianchuo2((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setShijianchuo2(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setShijianchuo2(null);
      }
   }
    if(map.containsKey("gongshi1")) {
      Object obj = map.get("gongshi1");
      if(obj != null) {
        if(obj instanceof String){
            this.setGongshi1((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("zhengxing1")) {
      Object obj = map.get("zhengxing1");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setZhengxing1((Long)obj);
        } else if(obj instanceof String) {
            this.setZhengxing1(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setZhengxing1(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("zhengxing2")) {
      Object obj = map.get("zhengxing2");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setZhengxing2((Long)obj);
        } else if(obj instanceof String) {
            this.setZhengxing2(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setZhengxing2(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("meiju1")) {
      Object obj = map.get("meiju1");
      if(obj != null) {
        if(obj instanceof String){
            this.setMeiju1((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
