package com.xforceplus.ultraman.app.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctraincuizheng2.entity.Autotestobjectcode;
import com.xforceplus.ultraman.app.jctraincuizheng2.service.IAutotestobjectcodeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * autotestobjectcode前端控制器
 *
 * @author ultraman
 * @date 2021-11-08
 */
@RestController
public class AutotestobjectcodeController {

  @Autowired
  private IAutotestobjectcodeService autotestobjectcodeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autotestobjectcode autotestobjectcode
   * @return
   */
  @GetMapping("/autotestobjectcodes" )
  public XfR getAutotestobjectcodes(XfPage page, Autotestobjectcode autotestobjectcode) {
    return XfR.ok(autotestobjectcodeServiceImpl.page(page, Wrappers.query(autotestobjectcode)));
  }

  /**
   * 通过id查询autotestobjectcode
   * @param  id
   * @return XfR
   */
  @GetMapping("/autotestobjectcodes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autotestobjectcodeServiceImpl.getById(id));
  }

  /**
   * 新增autotestobjectcode
   * @param autotestobjectcode autotestobjectcode
   * @return XfR
   */
  @PostMapping("/autotestobjectcodes")
  public XfR save(@RequestBody Autotestobjectcode autotestobjectcode) {
     return XfR.ok(autotestobjectcodeServiceImpl.save(autotestobjectcode));
  }

  /**
   * 修改-传入修改后的全部数据autotestobjectcode
   * @param autotestobjectcode autotestobjectcode
   * @return XfR
   */
  @PutMapping("/autotestobjectcodes/{id}")
  public XfR putUpdate(@RequestBody Autotestobjectcode autotestobjectcode,@PathVariable Long id) {
      autotestobjectcode.setId(id);
      return XfR.ok(autotestobjectcodeServiceImpl.updateById(autotestobjectcode));
  }

  /**
   * 修改-传入修改的数据autotestobjectcode
   * @param autotestobjectcode autotestobjectcode
   * @return XfR
   */
  @PatchMapping("/autotestobjectcodes/{id}")
  public XfR patchUpdate(@RequestBody Autotestobjectcode autotestobjectcode,@PathVariable Long id) {
      Autotestobjectcode upautotestobjectcode = autotestobjectcodeServiceImpl.getById(id);
      if(upautotestobjectcode != null){
        upautotestobjectcode = ObjectCopyUtils.copyProperties(autotestobjectcode,upautotestobjectcode,true);
      }
      return XfR.ok(autotestobjectcodeServiceImpl.updateById(upautotestobjectcode));
  }

  /**
   * 通过id删除autotestobjectcode
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autotestobjectcodes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autotestobjectcodeServiceImpl.removeById(id));
  }

  @PostMapping("/autotestobjectcodes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autotestobjectcode");
     params.put("request", condition);

     return XfR.ok(autotestobjectcodeServiceImpl.querys(params));
  }

}
