package com.xforceplus.ultraman.app.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctraincuizheng2.entity.Testduozid2;
import com.xforceplus.ultraman.app.jctraincuizheng2.service.ITestduozid2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testduozid2前端控制器
 *
 * @author ultraman
 * @date 2021-11-08
 */
@RestController
public class Testduozid2Controller {

  @Autowired
  private ITestduozid2Service testduozid2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testduozid2 testduozid2
   * @return
   */
  @GetMapping("/testduozid2s" )
  public XfR getTestduozid2s(XfPage page, Testduozid2 testduozid2) {
    return XfR.ok(testduozid2ServiceImpl.page(page, Wrappers.query(testduozid2)));
  }

  /**
   * 通过id查询testduozid2
   * @param  id
   * @return XfR
   */
  @GetMapping("/testduozid2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testduozid2ServiceImpl.getById(id));
  }

  /**
   * 新增testduozid2
   * @param testduozid2 testduozid2
   * @return XfR
   */
  @PostMapping("/testduozid2s")
  public XfR save(@RequestBody Testduozid2 testduozid2) {
     return XfR.ok(testduozid2ServiceImpl.save(testduozid2));
  }

  /**
   * 修改-传入修改后的全部数据testduozid2
   * @param testduozid2 testduozid2
   * @return XfR
   */
  @PutMapping("/testduozid2s/{id}")
  public XfR putUpdate(@RequestBody Testduozid2 testduozid2,@PathVariable Long id) {
      testduozid2.setId(id);
      return XfR.ok(testduozid2ServiceImpl.updateById(testduozid2));
  }

  /**
   * 修改-传入修改的数据testduozid2
   * @param testduozid2 testduozid2
   * @return XfR
   */
  @PatchMapping("/testduozid2s/{id}")
  public XfR patchUpdate(@RequestBody Testduozid2 testduozid2,@PathVariable Long id) {
      Testduozid2 uptestduozid2 = testduozid2ServiceImpl.getById(id);
      if(uptestduozid2 != null){
        uptestduozid2 = ObjectCopyUtils.copyProperties(testduozid2,uptestduozid2,true);
      }
      return XfR.ok(testduozid2ServiceImpl.updateById(uptestduozid2));
  }

  /**
   * 通过id删除testduozid2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testduozid2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testduozid2ServiceImpl.removeById(id));
  }

  @PostMapping("/testduozid2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testduozid2");
     params.put("request", condition);

     return XfR.ok(testduozid2ServiceImpl.querys(params));
  }

}
