package com.xforceplus.ultraman.app.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctraincuizheng2.entity.Autotestmeijuxing;
import com.xforceplus.ultraman.app.jctraincuizheng2.service.IAutotestmeijuxingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * autotestmeijuxing前端控制器
 *
 * @author ultraman
 * @date 2021-11-20
 */
@RestController
public class AutotestmeijuxingController {

  @Autowired
  private IAutotestmeijuxingService autotestmeijuxingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autotestmeijuxing autotestmeijuxing
   * @return
   */
  @GetMapping("/autotestmeijuxings" )
  public XfR getAutotestmeijuxings(XfPage page, Autotestmeijuxing autotestmeijuxing) {
    return XfR.ok(autotestmeijuxingServiceImpl.page(page, Wrappers.query(autotestmeijuxing)));
  }

  /**
   * 通过id查询autotestmeijuxing
   * @param  id
   * @return XfR
   */
  @GetMapping("/autotestmeijuxings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autotestmeijuxingServiceImpl.getById(id));
  }

  /**
   * 新增autotestmeijuxing
   * @param autotestmeijuxing autotestmeijuxing
   * @return XfR
   */
  @PostMapping("/autotestmeijuxings")
  public XfR save(@RequestBody Autotestmeijuxing autotestmeijuxing) {
     return XfR.ok(autotestmeijuxingServiceImpl.save(autotestmeijuxing));
  }

  /**
   * 修改-传入修改后的全部数据autotestmeijuxing
   * @param autotestmeijuxing autotestmeijuxing
   * @return XfR
   */
  @PutMapping("/autotestmeijuxings/{id}")
  public XfR putUpdate(@RequestBody Autotestmeijuxing autotestmeijuxing,@PathVariable Long id) {
      autotestmeijuxing.setId(id);
      return XfR.ok(autotestmeijuxingServiceImpl.updateById(autotestmeijuxing));
  }

  /**
   * 修改-传入修改的数据autotestmeijuxing
   * @param autotestmeijuxing autotestmeijuxing
   * @return XfR
   */
  @PatchMapping("/autotestmeijuxings/{id}")
  public XfR patchUpdate(@RequestBody Autotestmeijuxing autotestmeijuxing,@PathVariable Long id) {
      Autotestmeijuxing upautotestmeijuxing = autotestmeijuxingServiceImpl.getById(id);
      if(upautotestmeijuxing != null){
        upautotestmeijuxing = ObjectCopyUtils.copyProperties(autotestmeijuxing,upautotestmeijuxing,true);
      }
      return XfR.ok(autotestmeijuxingServiceImpl.updateById(upautotestmeijuxing));
  }

  /**
   * 通过id删除autotestmeijuxing
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autotestmeijuxings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autotestmeijuxingServiceImpl.removeById(id));
  }

  @PostMapping("/autotestmeijuxings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autotestmeijuxing");
     params.put("request", condition);

     return XfR.ok(autotestmeijuxingServiceImpl.querys(params));
  }

}
