package com.xforceplus.ultraman.app.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctraincuizheng2.entity.Autotestzhengxin;
import com.xforceplus.ultraman.app.jctraincuizheng2.service.IAutotestzhengxinService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * autotestzhengxin前端控制器
 *
 * @author ultraman
 * @date 2021-12-28
 */
@RestController
public class AutotestzhengxinController {

  @Autowired
  private IAutotestzhengxinService autotestzhengxinServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autotestzhengxin autotestzhengxin
   * @return
   */
  @GetMapping("/autotestzhengxins" )
  public XfR getAutotestzhengxins(XfPage page, Autotestzhengxin autotestzhengxin) {
    return XfR.ok(autotestzhengxinServiceImpl.page(page, Wrappers.query(autotestzhengxin)));
  }

  /**
   * 通过id查询autotestzhengxin
   * @param  id
   * @return XfR
   */
  @GetMapping("/autotestzhengxins/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autotestzhengxinServiceImpl.getById(id));
  }

  /**
   * 新增autotestzhengxin
   * @param autotestzhengxin autotestzhengxin
   * @return XfR
   */
  @PostMapping("/autotestzhengxins")
  public XfR save(@RequestBody Autotestzhengxin autotestzhengxin) {
     return XfR.ok(autotestzhengxinServiceImpl.save(autotestzhengxin));
  }

  /**
   * 修改-传入修改后的全部数据autotestzhengxin
   * @param autotestzhengxin autotestzhengxin
   * @return XfR
   */
  @PutMapping("/autotestzhengxins/{id}")
  public XfR putUpdate(@RequestBody Autotestzhengxin autotestzhengxin,@PathVariable Long id) {
      autotestzhengxin.setId(id);
      return XfR.ok(autotestzhengxinServiceImpl.updateById(autotestzhengxin));
  }

  /**
   * 修改-传入修改的数据autotestzhengxin
   * @param autotestzhengxin autotestzhengxin
   * @return XfR
   */
  @PatchMapping("/autotestzhengxins/{id}")
  public XfR patchUpdate(@RequestBody Autotestzhengxin autotestzhengxin,@PathVariable Long id) {
      Autotestzhengxin upautotestzhengxin = autotestzhengxinServiceImpl.getById(id);
      if(upautotestzhengxin != null){
        upautotestzhengxin = ObjectCopyUtils.copyProperties(autotestzhengxin,upautotestzhengxin,true);
      }
      return XfR.ok(autotestzhengxinServiceImpl.updateById(upautotestzhengxin));
  }

  /**
   * 通过id删除autotestzhengxin
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autotestzhengxins/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autotestzhengxinServiceImpl.removeById(id));
  }

  @PostMapping("/autotestzhengxins/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autotestzhengxin");
     params.put("request", condition);

     return XfR.ok(autotestzhengxinServiceImpl.querys(params));
  }

}
