package com.xforceplus.ultraman.app.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctraincuizheng2.entity.Autotestzhifuchuan;
import com.xforceplus.ultraman.app.jctraincuizheng2.service.IAutotestzhifuchuanService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 测试字符串前端控制器
 *
 * @author ultraman
 * @date 2021-12-30
 */
@RestController
public class AutotestzhifuchuanController {

  @Autowired
  private IAutotestzhifuchuanService autotestzhifuchuanServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autotestzhifuchuan 测试字符串
   * @return
   */
  @GetMapping("/autotestzhifuchuans" )
  public XfR getAutotestzhifuchuans(XfPage page, Autotestzhifuchuan autotestzhifuchuan) {
    return XfR.ok(autotestzhifuchuanServiceImpl.page(page, Wrappers.query(autotestzhifuchuan)));
  }

  /**
   * 通过id查询测试字符串
   * @param  id
   * @return XfR
   */
  @GetMapping("/autotestzhifuchuans/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autotestzhifuchuanServiceImpl.getById(id));
  }

  /**
   * 新增测试字符串
   * @param autotestzhifuchuan 测试字符串
   * @return XfR
   */
  @PostMapping("/autotestzhifuchuans")
  public XfR save(@RequestBody Autotestzhifuchuan autotestzhifuchuan) {
     return XfR.ok(autotestzhifuchuanServiceImpl.save(autotestzhifuchuan));
  }

  /**
   * 修改-传入修改后的全部数据测试字符串
   * @param autotestzhifuchuan 测试字符串
   * @return XfR
   */
  @PutMapping("/autotestzhifuchuans/{id}")
  public XfR putUpdate(@RequestBody Autotestzhifuchuan autotestzhifuchuan,@PathVariable Long id) {
      autotestzhifuchuan.setId(id);
      return XfR.ok(autotestzhifuchuanServiceImpl.updateById(autotestzhifuchuan));
  }

  /**
   * 修改-传入修改的数据测试字符串
   * @param autotestzhifuchuan 测试字符串
   * @return XfR
   */
  @PatchMapping("/autotestzhifuchuans/{id}")
  public XfR patchUpdate(@RequestBody Autotestzhifuchuan autotestzhifuchuan,@PathVariable Long id) {
      Autotestzhifuchuan upautotestzhifuchuan = autotestzhifuchuanServiceImpl.getById(id);
      if(upautotestzhifuchuan != null){
        upautotestzhifuchuan = ObjectCopyUtils.copyProperties(autotestzhifuchuan,upautotestzhifuchuan,true);
      }
      return XfR.ok(autotestzhifuchuanServiceImpl.updateById(upautotestzhifuchuan));
  }

  /**
   * 通过id删除测试字符串
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autotestzhifuchuans/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autotestzhifuchuanServiceImpl.removeById(id));
  }

  @PostMapping("/autotestzhifuchuans/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autotestzhifuchuan");
     params.put("request", condition);

     return XfR.ok(autotestzhifuchuanServiceImpl.querys(params));
  }

}
