package com.xforceplus.ultraman.app.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctraincuizheng2.entity.Yanzwent1;
import com.xforceplus.ultraman.app.jctraincuizheng2.service.IYanzwent1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * yanzwent1前端控制器
 *
 * @author ultraman
 * @date 2022-01-05
 */
@RestController
public class Yanzwent1Controller {

  @Autowired
  private IYanzwent1Service yanzwent1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yanzwent1 yanzwent1
   * @return
   */
  @GetMapping("/yanzwent1s" )
  public XfR getYanzwent1s(XfPage page, Yanzwent1 yanzwent1) {
    return XfR.ok(yanzwent1ServiceImpl.page(page, Wrappers.query(yanzwent1)));
  }

  /**
   * 通过id查询yanzwent1
   * @param  id
   * @return XfR
   */
  @GetMapping("/yanzwent1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yanzwent1ServiceImpl.getById(id));
  }

  /**
   * 新增yanzwent1
   * @param yanzwent1 yanzwent1
   * @return XfR
   */
  @PostMapping("/yanzwent1s")
  public XfR save(@RequestBody Yanzwent1 yanzwent1) {
     return XfR.ok(yanzwent1ServiceImpl.save(yanzwent1));
  }

  /**
   * 修改-传入修改后的全部数据yanzwent1
   * @param yanzwent1 yanzwent1
   * @return XfR
   */
  @PutMapping("/yanzwent1s/{id}")
  public XfR putUpdate(@RequestBody Yanzwent1 yanzwent1,@PathVariable Long id) {
      yanzwent1.setId(id);
      return XfR.ok(yanzwent1ServiceImpl.updateById(yanzwent1));
  }

  /**
   * 修改-传入修改的数据yanzwent1
   * @param yanzwent1 yanzwent1
   * @return XfR
   */
  @PatchMapping("/yanzwent1s/{id}")
  public XfR patchUpdate(@RequestBody Yanzwent1 yanzwent1,@PathVariable Long id) {
      Yanzwent1 upyanzwent1 = yanzwent1ServiceImpl.getById(id);
      if(upyanzwent1 != null){
        upyanzwent1 = ObjectCopyUtils.copyProperties(yanzwent1,upyanzwent1,true);
      }
      return XfR.ok(yanzwent1ServiceImpl.updateById(upyanzwent1));
  }

  /**
   * 通过id删除yanzwent1
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yanzwent1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yanzwent1ServiceImpl.removeById(id));
  }

  @PostMapping("/yanzwent1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "yanzwent1");
     params.put("request", condition);

     return XfR.ok(yanzwent1ServiceImpl.querys(params));
  }

}
