package com.xforceplus.ultraman.app.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctraincuizheng2.entity.Yanzwent2;
import com.xforceplus.ultraman.app.jctraincuizheng2.service.IYanzwent2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * yanzwent2前端控制器
 *
 * @author ultraman
 * @date 2022-01-05
 */
@RestController
public class Yanzwent2Controller {

  @Autowired
  private IYanzwent2Service yanzwent2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yanzwent2 yanzwent2
   * @return
   */
  @GetMapping("/yanzwent2s" )
  public XfR getYanzwent2s(XfPage page, Yanzwent2 yanzwent2) {
    return XfR.ok(yanzwent2ServiceImpl.page(page, Wrappers.query(yanzwent2)));
  }

  /**
   * 通过id查询yanzwent2
   * @param  id
   * @return XfR
   */
  @GetMapping("/yanzwent2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yanzwent2ServiceImpl.getById(id));
  }

  /**
   * 新增yanzwent2
   * @param yanzwent2 yanzwent2
   * @return XfR
   */
  @PostMapping("/yanzwent2s")
  public XfR save(@RequestBody Yanzwent2 yanzwent2) {
     return XfR.ok(yanzwent2ServiceImpl.save(yanzwent2));
  }

  /**
   * 修改-传入修改后的全部数据yanzwent2
   * @param yanzwent2 yanzwent2
   * @return XfR
   */
  @PutMapping("/yanzwent2s/{id}")
  public XfR putUpdate(@RequestBody Yanzwent2 yanzwent2,@PathVariable Long id) {
      yanzwent2.setId(id);
      return XfR.ok(yanzwent2ServiceImpl.updateById(yanzwent2));
  }

  /**
   * 修改-传入修改的数据yanzwent2
   * @param yanzwent2 yanzwent2
   * @return XfR
   */
  @PatchMapping("/yanzwent2s/{id}")
  public XfR patchUpdate(@RequestBody Yanzwent2 yanzwent2,@PathVariable Long id) {
      Yanzwent2 upyanzwent2 = yanzwent2ServiceImpl.getById(id);
      if(upyanzwent2 != null){
        upyanzwent2 = ObjectCopyUtils.copyProperties(yanzwent2,upyanzwent2,true);
      }
      return XfR.ok(yanzwent2ServiceImpl.updateById(upyanzwent2));
  }

  /**
   * 通过id删除yanzwent2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yanzwent2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yanzwent2ServiceImpl.removeById(id));
  }

  @PostMapping("/yanzwent2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "yanzwent2");
     params.put("request", condition);

     return XfR.ok(yanzwent2ServiceImpl.querys(params));
  }

}
