package com.xforceplus.ultraman.app.jcultramanljj.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_status
 * </p>
 *
 * @author ultraman
 * @since 2025-01-15
 */
public enum BizOrderStatus {

    _1("1", "待开票"),
    _0("0", "待审批"),
    _2("2", "已开票"),
    _3("3", "上传失败"),
    _4("4", "已驳回");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BizOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "0":
                return _0;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
