package com.xforceplus.ultraman.app.jcultramanljj.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * fapiaoleixing
 * </p>
 *
 * @author ultraman
 * @since 2025-01-15
 */
public enum Fapiaoleixing {

    C("c", "税控普票"),
    S("s", "税控专票"),
    CE("ce", "税控电子普票"),
    SE("se", "税控电子专票"),
    QC("qc", "数电普票"),
    QS("qs", "数电专票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Fapiaoleixing(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Fapiaoleixing fromCode(String code){
        switch(code) {
            case "c":
                return C;
            case "s":
                return S;
            case "ce":
                return CE;
            case "se":
                return SE;
            case "qc":
                return QC;
            case "qs":
                return QS;
            default:
                return null;
        }
    }
}
