package com.xforceplus.ultraman.app.jcultramanljj.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-01-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Danjuzhuxinxi implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 单据类型
   */
  private String djlx;

  /**
   * 单据号
   */
  private String djh;

  /**
   * 发票类型
   */
  private String fplx;

  /**
   * 购方编码
   */
  private String gfbm;

  /**
   * 购方名称
   */
  private String gfmc;

  /**
   * 购方税号
   */
  private String gfsh;

  /**
   * 销方编码
   */
  private String xfbm;

  /**
   * 销方名称
   */
  private String xfmc;

  /**
   * 销方税号
   */
  private String xfsh;

  /**
   * 含税金额
   */
  private String hsje;

  /**
   * 不含税金额
   */
  private String bhsje;

  /**
   * 税额
   */
  private String se;

  /**
   * 已匹配含税金额
   */
  private String ypphsje;

  /**
   * 已匹配不含税金额
   */
  private String yppbhsje;

  /**
   * 已匹配税额
   */
  private String yppse;

  /**
   * 待匹配不含税金额
   */
  private String dppbhsje;

  /**
   * 待匹配含税金额
   */
  private String dpphsje;

  /**
   * 待匹配税额
   */
  private String dppse;

  /**
   * 单据状态
   */
  private String djzt;

  /**
   * 单据ID
   */
  @TableField("djID")
  private String djID;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("djlx", djlx);
      map.put("djh", djh);
      map.put("fplx", fplx);
      map.put("gfbm", gfbm);
      map.put("gfmc", gfmc);
      map.put("gfsh", gfsh);
      map.put("xfbm", xfbm);
      map.put("xfmc", xfmc);
      map.put("xfsh", xfsh);
      map.put("hsje", hsje);
      map.put("bhsje", bhsje);
      map.put("se", se);
      map.put("ypphsje", ypphsje);
      map.put("yppbhsje", yppbhsje);
      map.put("yppse", yppse);
      map.put("dppbhsje", dppbhsje);
      map.put("dpphsje", dpphsje);
      map.put("dppse", dppse);
      map.put("djzt", djzt);
      map.put("djID", djID);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static Danjuzhuxinxi fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Danjuzhuxinxi entity = new Danjuzhuxinxi();
    if(map.containsKey("djlx")) {
      Object obj = map.get("djlx");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDjlx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("djh")) {
      Object obj = map.get("djh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDjh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fplx")) {
      Object obj = map.get("fplx");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFplx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gfbm")) {
      Object obj = map.get("gfbm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGfbm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gfmc")) {
      Object obj = map.get("gfmc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGfmc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gfsh")) {
      Object obj = map.get("gfsh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGfsh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xfbm")) {
      Object obj = map.get("xfbm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXfbm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xfmc")) {
      Object obj = map.get("xfmc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXfmc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xfsh")) {
      Object obj = map.get("xfsh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXfsh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hsje")) {
      Object obj = map.get("hsje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHsje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bhsje")) {
      Object obj = map.get("bhsje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBhsje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("se")) {
      Object obj = map.get("se");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ypphsje")) {
      Object obj = map.get("ypphsje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYpphsje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("yppbhsje")) {
      Object obj = map.get("yppbhsje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYppbhsje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("yppse")) {
      Object obj = map.get("yppse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYppse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dppbhsje")) {
      Object obj = map.get("dppbhsje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDppbhsje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dpphsje")) {
      Object obj = map.get("dpphsje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDpphsje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dppse")) {
      Object obj = map.get("dppse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDppse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("djzt")) {
      Object obj = map.get("djzt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDjzt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("djID")) {
      Object obj = map.get("djID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDjID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("djlx")) {
      Object obj = map.get("djlx");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDjlx((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("djh")) {
      Object obj = map.get("djh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDjh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fplx")) {
      Object obj = map.get("fplx");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFplx((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gfbm")) {
      Object obj = map.get("gfbm");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGfbm((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gfmc")) {
      Object obj = map.get("gfmc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGfmc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gfsh")) {
      Object obj = map.get("gfsh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGfsh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("xfbm")) {
      Object obj = map.get("xfbm");
      if(obj != null) {
        if(obj instanceof String) {
          this.setXfbm((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("xfmc")) {
      Object obj = map.get("xfmc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setXfmc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("xfsh")) {
      Object obj = map.get("xfsh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setXfsh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hsje")) {
      Object obj = map.get("hsje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHsje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bhsje")) {
      Object obj = map.get("bhsje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBhsje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("se")) {
      Object obj = map.get("se");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSe((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ypphsje")) {
      Object obj = map.get("ypphsje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYpphsje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("yppbhsje")) {
      Object obj = map.get("yppbhsje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYppbhsje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("yppse")) {
      Object obj = map.get("yppse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYppse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dppbhsje")) {
      Object obj = map.get("dppbhsje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDppbhsje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dpphsje")) {
      Object obj = map.get("dpphsje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDpphsje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dppse")) {
      Object obj = map.get("dppse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDppse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("djzt")) {
      Object obj = map.get("djzt");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDjzt((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("djID")) {
      Object obj = map.get("djID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDjID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
