package com.xforceplus.ultraman.app.jcultramanljj.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-01-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Hongzi implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 审批单号
   */
  private String spdh;

  /**
   * 原发票代码
   */
  private String yfpdm;

  /**
   * 原发票号
   */
  private String yfph;

  /**
   * 含税金额
   */
  private String hsje;

  /**
   * 不含税金额
   */
  private String bhsje;

  /**
   * 税额
   */
  private String se;

  /**
   * 红字确认单号
   */
  private String hzqrdh;

  /**
   * 红字申请时间
   */
  private String hzsqsj;

  /**
   * 红字确认单状态
   */
  private String hzqrdzt;

  /**
   * 红字发票号
   */
  private String hzfph;

  /**
   * 红字发票日期
   */
  private String hzfprq;

  /**
   * 单据ID
   */
  @TableField("djID")
  private String djID;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;


  /**
   * 对一关联关系 关联对象 danjuzhuxinxi
   */
    private Long okkId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("spdh", spdh);
      map.put("yfpdm", yfpdm);
      map.put("yfph", yfph);
      map.put("hsje", hsje);
      map.put("bhsje", bhsje);
      map.put("se", se);
      map.put("hzqrdh", hzqrdh);
      map.put("hzsqsj", hzsqsj);
      map.put("hzqrdzt", hzqrdzt);
      map.put("hzfph", hzfph);
      map.put("hzfprq", hzfprq);
      map.put("djID", djID);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

       map.put("okk.id", okkId);
      return map;
  }

  public static Hongzi fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Hongzi entity = new Hongzi();
    if(map.containsKey("spdh")) {
      Object obj = map.get("spdh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpdh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("yfpdm")) {
      Object obj = map.get("yfpdm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYfpdm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("yfph")) {
      Object obj = map.get("yfph");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYfph((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hsje")) {
      Object obj = map.get("hsje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHsje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bhsje")) {
      Object obj = map.get("bhsje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBhsje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("se")) {
      Object obj = map.get("se");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hzqrdh")) {
      Object obj = map.get("hzqrdh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHzqrdh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hzsqsj")) {
      Object obj = map.get("hzsqsj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHzsqsj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hzqrdzt")) {
      Object obj = map.get("hzqrdzt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHzqrdzt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hzfph")) {
      Object obj = map.get("hzfph");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHzfph((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hzfprq")) {
      Object obj = map.get("hzfprq");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHzfprq((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("djID")) {
      Object obj = map.get("djID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDjID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("okk.id")) {
        Object obj = map.get("okk.id");
      if(obj instanceof Long) {
        entity.setOkkId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setOkkId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("spdh")) {
      Object obj = map.get("spdh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpdh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("yfpdm")) {
      Object obj = map.get("yfpdm");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYfpdm((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("yfph")) {
      Object obj = map.get("yfph");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYfph((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hsje")) {
      Object obj = map.get("hsje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHsje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bhsje")) {
      Object obj = map.get("bhsje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBhsje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("se")) {
      Object obj = map.get("se");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSe((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hzqrdh")) {
      Object obj = map.get("hzqrdh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHzqrdh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hzsqsj")) {
      Object obj = map.get("hzsqsj");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHzsqsj((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hzqrdzt")) {
      Object obj = map.get("hzqrdzt");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHzqrdzt((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hzfph")) {
      Object obj = map.get("hzfph");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHzfph((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hzfprq")) {
      Object obj = map.get("hzfprq");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHzfprq((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("djID")) {
      Object obj = map.get("djID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDjID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("okk.id")) {
        Object obj = map.get("okk.id");
        if(obj instanceof Long) {
          this.setOkkId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOkkId(Long.parseLong((String)obj));
        }
      }
  }
}
