package com.xforceplus.ultraman.app.jcultramanljj.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-01-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Zhineng implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 规则名称
   */
  private String guizemingcheng;

  /**
   * 规则ID
   */
  @TableField("guizeID")
  private String guizeID;

  /**
   * 使用方
   */
  private String shiyongfang;

  /**
   * 单据类型
   */
  private String danjuleixing;

  /**
   * 发票号
   */
  private String fapiaohao;

  /**
   * 规则优先级
   */
  private String youxianji;

  /**
   * 生效范围
   */
  private String shengxiaofanwei;

  /**
   * 组别
   */
  private String zubie;

  /**
   * 时间范围
   */
  private String shijianfanwei;

  /**
   * 认证状态
   */
  private String renzhengzhuangtai;

  /**
   * 红冲原因
   */
  private String hongchongyuanyin;

  /**
   * 购方名称是否一致
   */
  private Boolean goufangmingcheng;

  /**
   * 购方税号是否一致
   */
  private Boolean goufangshuihao;

  /**
   * 销方名称是否一致
   */
  private Boolean xiaofangmingcheng;

  /**
   * 销方税号是否一致
   */
  private Boolean xiaofangshuihao;

  /**
   * 发票类型
   */
  private String fapiaoleixing;

  /**
   * 税率是否一致
   */
  private Boolean shuilv;

  /**
   * 商品名称
   */
  private String shangpinmingcheng;

  /**
   * 单价是否一致
   */
  private Boolean buhanshuidanjia;

  /**
   * 金额容差
   */
  private String jinerongcha;

  /**
   * 时间顺序
   */
  private String shijianshunxu;

  /**
   * 反算模式
   */
  private String fansuanmoshi;

  /**
   * 是否启用
   */
  private Boolean shifouqiyong;

  /**
   * 租户名称
   */
  private String zuhumingcheng;

  /**
   * 租户代码
   */
  private String zuhudaima;

  /**
   * 租户ID
   */
  @TableField("zuhuID")
  private String zuhuID;

  /**
   * 创建时间
   */
  private String chuangjianshijian;

  /**
   * 修改时间
   */
  private String xiugaishijian;

  /**
   * 版本
   */
  private String banben;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 计价方式
   */
  private String jijiafangshi;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("guizemingcheng", guizemingcheng);
      map.put("guizeID", guizeID);
      map.put("shiyongfang", shiyongfang);
      map.put("danjuleixing", danjuleixing);
      map.put("fapiaohao", fapiaohao);
      map.put("youxianji", youxianji);
      map.put("shengxiaofanwei", shengxiaofanwei);
      map.put("zubie", zubie);
      map.put("shijianfanwei", shijianfanwei);
      map.put("renzhengzhuangtai", renzhengzhuangtai);
      map.put("hongchongyuanyin", hongchongyuanyin);
      map.put("goufangmingcheng", goufangmingcheng);
      map.put("goufangshuihao", goufangshuihao);
      map.put("xiaofangmingcheng", xiaofangmingcheng);
      map.put("xiaofangshuihao", xiaofangshuihao);
      map.put("fapiaoleixing", fapiaoleixing);
      map.put("shuilv", shuilv);
      map.put("shangpinmingcheng", shangpinmingcheng);
      map.put("buhanshuidanjia", buhanshuidanjia);
      map.put("jinerongcha", jinerongcha);
      map.put("shijianshunxu", shijianshunxu);
      map.put("fansuanmoshi", fansuanmoshi);
      map.put("shifouqiyong", shifouqiyong);
      map.put("zuhumingcheng", zuhumingcheng);
      map.put("zuhudaima", zuhudaima);
      map.put("zuhuID", zuhuID);
      map.put("chuangjianshijian", chuangjianshijian);
      map.put("xiugaishijian", xiugaishijian);
      map.put("banben", banben);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("jijiafangshi", jijiafangshi);

      return map;
  }

  public static Zhineng fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Zhineng entity = new Zhineng();
    if(map.containsKey("guizemingcheng")) {
      Object obj = map.get("guizemingcheng");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGuizemingcheng((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("guizeID")) {
      Object obj = map.get("guizeID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGuizeID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shiyongfang")) {
      Object obj = map.get("shiyongfang");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShiyongfang((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("danjuleixing")) {
      Object obj = map.get("danjuleixing");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDanjuleixing((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fapiaohao")) {
      Object obj = map.get("fapiaohao");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFapiaohao((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("youxianji")) {
      Object obj = map.get("youxianji");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYouxianji((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shengxiaofanwei")) {
      Object obj = map.get("shengxiaofanwei");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShengxiaofanwei((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zubie")) {
      Object obj = map.get("zubie");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZubie((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shijianfanwei")) {
      Object obj = map.get("shijianfanwei");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShijianfanwei((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("renzhengzhuangtai")) {
      Object obj = map.get("renzhengzhuangtai");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRenzhengzhuangtai((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hongchongyuanyin")) {
      Object obj = map.get("hongchongyuanyin");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHongchongyuanyin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goufangmingcheng")) {
      Object obj = map.get("goufangmingcheng");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setGoufangmingcheng((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoufangmingcheng(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("goufangshuihao")) {
      Object obj = map.get("goufangshuihao");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setGoufangshuihao((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoufangshuihao(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("xiaofangmingcheng")) {
      Object obj = map.get("xiaofangmingcheng");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setXiaofangmingcheng((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setXiaofangmingcheng(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("xiaofangshuihao")) {
      Object obj = map.get("xiaofangshuihao");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setXiaofangshuihao((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setXiaofangshuihao(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("fapiaoleixing")) {
      Object obj = map.get("fapiaoleixing");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFapiaoleixing((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shuilv")) {
      Object obj = map.get("shuilv");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setShuilv((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShuilv(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("shangpinmingcheng")) {
      Object obj = map.get("shangpinmingcheng");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShangpinmingcheng((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buhanshuidanjia")) {
      Object obj = map.get("buhanshuidanjia");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBuhanshuidanjia((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuhanshuidanjia(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("jinerongcha")) {
      Object obj = map.get("jinerongcha");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJinerongcha((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shijianshunxu")) {
      Object obj = map.get("shijianshunxu");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShijianshunxu((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fansuanmoshi")) {
      Object obj = map.get("fansuanmoshi");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFansuanmoshi((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shifouqiyong")) {
      Object obj = map.get("shifouqiyong");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setShifouqiyong((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShifouqiyong(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("zuhumingcheng")) {
      Object obj = map.get("zuhumingcheng");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZuhumingcheng((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zuhudaima")) {
      Object obj = map.get("zuhudaima");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZuhudaima((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zuhuID")) {
      Object obj = map.get("zuhuID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZuhuID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chuangjianshijian")) {
      Object obj = map.get("chuangjianshijian");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChuangjianshijian((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xiugaishijian")) {
      Object obj = map.get("xiugaishijian");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXiugaishijian((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("banben")) {
      Object obj = map.get("banben");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBanben((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jijiafangshi")) {
      Object obj = map.get("jijiafangshi");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJijiafangshi((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("guizemingcheng")) {
      Object obj = map.get("guizemingcheng");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGuizemingcheng((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("guizeID")) {
      Object obj = map.get("guizeID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGuizeID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shiyongfang")) {
      Object obj = map.get("shiyongfang");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShiyongfang((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("danjuleixing")) {
      Object obj = map.get("danjuleixing");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDanjuleixing((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fapiaohao")) {
      Object obj = map.get("fapiaohao");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFapiaohao((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("youxianji")) {
      Object obj = map.get("youxianji");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYouxianji((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shengxiaofanwei")) {
      Object obj = map.get("shengxiaofanwei");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShengxiaofanwei((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zubie")) {
      Object obj = map.get("zubie");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZubie((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shijianfanwei")) {
      Object obj = map.get("shijianfanwei");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShijianfanwei((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("renzhengzhuangtai")) {
      Object obj = map.get("renzhengzhuangtai");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRenzhengzhuangtai((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hongchongyuanyin")) {
      Object obj = map.get("hongchongyuanyin");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHongchongyuanyin((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goufangmingcheng")) {
      Object obj = map.get("goufangmingcheng");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setGoufangmingcheng((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoufangmingcheng(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("goufangshuihao")) {
      Object obj = map.get("goufangshuihao");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setGoufangshuihao((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoufangshuihao(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("xiaofangmingcheng")) {
      Object obj = map.get("xiaofangmingcheng");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setXiaofangmingcheng((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setXiaofangmingcheng(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("xiaofangshuihao")) {
      Object obj = map.get("xiaofangshuihao");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setXiaofangshuihao((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setXiaofangshuihao(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("fapiaoleixing")) {
      Object obj = map.get("fapiaoleixing");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFapiaoleixing((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shuilv")) {
      Object obj = map.get("shuilv");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setShuilv((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShuilv(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("shangpinmingcheng")) {
      Object obj = map.get("shangpinmingcheng");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShangpinmingcheng((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buhanshuidanjia")) {
      Object obj = map.get("buhanshuidanjia");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setBuhanshuidanjia((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBuhanshuidanjia(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("jinerongcha")) {
      Object obj = map.get("jinerongcha");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJinerongcha((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shijianshunxu")) {
      Object obj = map.get("shijianshunxu");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShijianshunxu((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fansuanmoshi")) {
      Object obj = map.get("fansuanmoshi");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFansuanmoshi((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shifouqiyong")) {
      Object obj = map.get("shifouqiyong");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setShifouqiyong((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShifouqiyong(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("zuhumingcheng")) {
      Object obj = map.get("zuhumingcheng");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZuhumingcheng((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zuhudaima")) {
      Object obj = map.get("zuhudaima");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZuhudaima((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zuhuID")) {
      Object obj = map.get("zuhuID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZuhuID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chuangjianshijian")) {
      Object obj = map.get("chuangjianshijian");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChuangjianshijian((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("xiugaishijian")) {
      Object obj = map.get("xiugaishijian");
      if(obj != null) {
        if(obj instanceof String) {
          this.setXiugaishijian((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("banben")) {
      Object obj = map.get("banben");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBanben((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jijiafangshi")) {
      Object obj = map.get("jijiafangshi");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJijiafangshi((String)obj);
        }
      } else {
      }
    }
  }
}
