package com.xforceplus.ultraman.app.jcultramanltt.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcultramanltt.entity.SalesInvoiceItem;
import com.xforceplus.ultraman.app.jcultramanltt.service.ISalesInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-11
 */
@RestController
public class SalesInvoiceItemController {

  @Autowired
  private ISalesInvoiceItemService salesInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/salesinvoiceitems" )
  public XfR getSalesInvoiceItems(XfPage page, SalesInvoiceItem salesInvoiceItem) {
    return XfR.ok(salesInvoiceItemServiceImpl.page(page, Wrappers.query(salesInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesinvoiceitems")
  public XfR save(@RequestBody SalesInvoiceItem salesInvoiceItem) {
     return XfR.ok(salesInvoiceItemServiceImpl.save(salesInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody SalesInvoiceItem salesInvoiceItem,@PathVariable Long id) {
      salesInvoiceItem.setId(id);
      return XfR.ok(salesInvoiceItemServiceImpl.updateById(salesInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody SalesInvoiceItem salesInvoiceItem,@PathVariable Long id) {
      SalesInvoiceItem upsalesInvoiceItem = salesInvoiceItemServiceImpl.getById(id);
      if(upsalesInvoiceItem != null){
        upsalesInvoiceItem = ObjectCopyUtils.copyProperties(salesInvoiceItem,upsalesInvoiceItem,true);
      }
      return XfR.ok(salesInvoiceItemServiceImpl.updateById(upsalesInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/salesinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_invoice_item");
     params.put("request", condition);

     return XfR.ok(salesInvoiceItemServiceImpl.querys(params));
  }

}
