package com.xforceplus.ultraman.app.jcultramanltt.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcultramanltt.entity.SalesInvoiceMain;
import com.xforceplus.ultraman.app.jcultramanltt.service.ISalesInvoiceMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-11
 */
@RestController
public class SalesInvoiceMainController {

  @Autowired
  private ISalesInvoiceMainService salesInvoiceMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesInvoiceMain ${table.comment}
   * @return
   */
  @GetMapping("/salesinvoicemains" )
  public XfR getSalesInvoiceMains(XfPage page, SalesInvoiceMain salesInvoiceMain) {
    return XfR.ok(salesInvoiceMainServiceImpl.page(page, Wrappers.query(salesInvoiceMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesinvoicemains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesInvoiceMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesInvoiceMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesinvoicemains")
  public XfR save(@RequestBody SalesInvoiceMain salesInvoiceMain) {
     return XfR.ok(salesInvoiceMainServiceImpl.save(salesInvoiceMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesInvoiceMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesinvoicemains/{id}")
  public XfR putUpdate(@RequestBody SalesInvoiceMain salesInvoiceMain,@PathVariable Long id) {
      salesInvoiceMain.setId(id);
      return XfR.ok(salesInvoiceMainServiceImpl.updateById(salesInvoiceMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesInvoiceMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesinvoicemains/{id}")
  public XfR patchUpdate(@RequestBody SalesInvoiceMain salesInvoiceMain,@PathVariable Long id) {
      SalesInvoiceMain upsalesInvoiceMain = salesInvoiceMainServiceImpl.getById(id);
      if(upsalesInvoiceMain != null){
        upsalesInvoiceMain = ObjectCopyUtils.copyProperties(salesInvoiceMain,upsalesInvoiceMain,true);
      }
      return XfR.ok(salesInvoiceMainServiceImpl.updateById(upsalesInvoiceMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesinvoicemains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesInvoiceMainServiceImpl.removeById(id));
  }

  @PostMapping("/salesinvoicemains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_invoice_main");
     params.put("request", condition);

     return XfR.ok(salesInvoiceMainServiceImpl.querys(params));
  }

}
