package com.xforceplus.ultraman.app.jcultramanocrdemo.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * chat_content_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-19
 */
public enum ChatContentTypeEnum {

    TEXT("text", "TEXT"),
    IMAGE_URL("image_url", "IMAGE_URL");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChatContentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChatContentTypeEnum fromCode(String code) {
        return Stream.of(ChatContentTypeEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
