package com.xforceplus.ultraman.app.jcultramanocrdemo.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * enable_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-19
 */
public enum EnableEnum {

    _0("0", "停用"),
    _1("1", "启用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EnableEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EnableEnum fromCode(String code) {
        return Stream.of(EnableEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
