package com.xforceplus.ultraman.app.jcultramanocrdemo.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ocr_channel
 * </p>
 *
 * @author ultraman
 * @since 2024-08-19
 */
public enum OcrChannel {

    _0("0", "来也"),
    _1("1", "微软");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OcrChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OcrChannel fromCode(String code) {
        return Stream.of(OcrChannel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
